/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import lombok.NonNull;

public final class MoreIterators {
    public static <T> Iterator<T> newReadOnlyIterator(final @NonNull Iterator<T> wrappedIterator) {
        if (wrappedIterator == null) {
            throw new NullPointerException("wrappedIterator is marked non-null but is null");
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return wrappedIterator.hasNext();
            }

            @Override
            public T next() {
                return wrappedIterator.next();
            }
        };
    }

    public static <T> Iterator<T> prepend(T prependElement, Iterator<T> prependTo) {
        return Iterators.concat(Collections.singletonList(prependElement).iterator(), prependTo);
    }

    public static <T> Iterator<T> of(T ... elements) {
        return Arrays.asList(elements).iterator();
    }

    private MoreIterators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

