/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Throwables;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Iterators;
import com.amazon.ws.emr.hadoop.fs.util.MoreIterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExceptionCollector
implements Iterable<Throwable> {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionCollector.class);
    private static final int DEFAULT_MAX_NUMBER_EXCEPTIONS = 100;
    private final List<Throwable> exceptions = new ArrayList<Throwable>();
    private final int maxNumberExceptions;
    private long droppedExceptions = 0L;

    public ExceptionCollector() {
        this(Integer.MAX_VALUE);
    }

    public ExceptionCollector(int maxNumberExceptions) {
        Preconditions.checkArgument(maxNumberExceptions > 0);
        this.maxNumberExceptions = maxNumberExceptions;
    }

    public static ExceptionCollector withDefaultMaxCollectedExceptions() {
        return new ExceptionCollector(100);
    }

    public void add(@NonNull Throwable exception) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        if (this.exceptions.size() >= this.maxNumberExceptions) {
            if (this.droppedExceptions == 0L) {
                logger.warn("Number of added exceptions exceeded {}. New exception(s) will be dropped.", (Object)this.maxNumberExceptions);
            }
            ++this.droppedExceptions;
            logger.debug("Dropped exception: ", exception);
        } else {
            this.exceptions.add(exception);
        }
    }

    public <X extends Throwable> void throwIfNotEmpty(@NonNull Supplier<X> exceptionToThrow) throws X {
        if (exceptionToThrow == null) {
            throw new NullPointerException("exceptionToThrow is marked non-null but is null");
        }
        if (this.exceptions.isEmpty()) {
            return;
        }
        Throwable toThrow = (Throwable)exceptionToThrow.get();
        toThrow.initCause(this.assembleSingleExceptionFromCollected());
        throw toThrow;
    }

    public <X extends Throwable> void rethrowIfNotEmpty(@NonNull Class<X> declaredType) throws X {
        if (declaredType == null) {
            throw new NullPointerException("declaredType is marked non-null but is null");
        }
        if (this.exceptions.isEmpty()) {
            return;
        }
        Throwable exception = this.assembleSingleExceptionFromCollected();
        Throwables.propagateIfPossible(exception, declaredType);
        throw new RuntimeException(exception);
    }

    public <X extends Throwable> ExceptionCollector rethrowIfFirstIs(@NonNull Class<X> rethrowType) throws X {
        if (rethrowType == null) {
            throw new NullPointerException("rethrowType is marked non-null but is null");
        }
        if (this.exceptions.isEmpty()) {
            return this;
        }
        Throwable cause = this.exceptions.get(0);
        if (rethrowType.isInstance(cause)) {
            throw (Throwable)rethrowType.cast(this.assembleSingleExceptionFromCollected());
        }
        return this;
    }

    @Override
    public Iterator<Throwable> iterator() {
        Iterator<Throwable> resultToWrap;
        if (this.droppedExceptions > 0L) {
            String exceptionDroppedMessage = String.format("%d exception(s) were dropped because max number of exceptions (%d) was exceeded", this.droppedExceptions, this.maxNumberExceptions);
            logger.warn(exceptionDroppedMessage);
            RuntimeException lastException = new RuntimeException(exceptionDroppedMessage);
            resultToWrap = Iterators.concat(this.exceptions.iterator(), ImmutableList.of(lastException).iterator());
        } else {
            resultToWrap = this.exceptions.iterator();
        }
        return MoreIterators.newReadOnlyIterator(resultToWrap);
    }

    public boolean isEmpty() {
        return this.exceptions.isEmpty();
    }

    private Throwable assembleSingleExceptionFromCollected() {
        Iterator<Throwable> exceptionsToAssemble = this.iterator();
        Throwable cause = exceptionsToAssemble.next();
        exceptionsToAssemble.forEachRemaining(toSuppress -> {
            if (cause != toSuppress) {
                cause.addSuppressed((Throwable)toSuppress);
            }
        });
        return cause;
    }
}

