/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.annotation.AnnotationProcessorImpl;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.bucket.BucketRegionStores;
import com.amazon.ws.emr.hadoop.fs.s3.lite.handler.HeadBucketRedirectHandler;
import com.amazon.ws.emr.hadoop.fs.s3.lite.handler.RequestIdLogger;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.handlers.RequestHandler2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.CommandLine;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.DefaultExecuteResultHandler;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.DefaultExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.ExecuteWatchdog;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.PumpStreamHandler;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.io.output.ByteArrayOutputStream;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import com.amazon.ws.emr.hadoop.fs.util.AmazonServiceExceptions;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.PlatformInfo;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmrFsUtils {
    private static final Logger logger = LoggerFactory.getLogger(EmrFsUtils.class);
    static final String S3_GOV_WEST_FIPS_ENDPOINT = "s3-fips-us-gov-west-1.amazonaws.com";
    private static final String jobFlowId = EmrFsUtils.getJobFlowId();
    private static final String DEFAULT_JOB_FLOW_ID = "UnknownJobFlowId";

    public static String getDefaultScheme() {
        return "s3n";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String execCmd(String cmd) {
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(1000L);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        executor.setWatchdog(watchdog);
        CommandLine commandLine = new CommandLine(cmd);
        try (ByteArrayOutputStream stdOutStream = new ByteArrayOutputStream();){
            String stdOut;
            int exitValue;
            Throwable throwable;
            ByteArrayOutputStream stdErrStream;
            block27: {
                String string;
                block28: {
                    stdErrStream = new ByteArrayOutputStream();
                    throwable = null;
                    PumpStreamHandler pumpStreamHandler = new PumpStreamHandler(stdOutStream, stdErrStream);
                    executor.setStreamHandler(pumpStreamHandler);
                    executor.execute(commandLine, resultHandler);
                    try {
                        resultHandler.waitFor();
                        exitValue = resultHandler.getExitValue();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    pumpStreamHandler.stop();
                    stdOut = stdOutStream.toString(StandardCharsets.UTF_8.name());
                    if (exitValue != 0) break block27;
                    string = stdOut;
                    if (stdErrStream == null) return string;
                    if (throwable == null) break block28;
                    try {
                        stdErrStream.close();
                        return string;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return string;
                    }
                }
                stdErrStream.close();
                return string;
            }
            try {
                try {
                    logger.warn("Non-zero exit value of {} returned by '{}'", (Object)exitValue, (Object)cmd);
                    logger.warn("stdout: {}", (Object)stdOut);
                    String stdErr = stdErrStream.toString(StandardCharsets.UTF_8.name());
                    logger.warn("stderr: {}", (Object)stdErr);
                    throw new RuntimeException(String.format("Non-zero exit value of %d returned by '%s'", exitValue, cmd));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (stdErrStream == null) throw throwable4;
                if (throwable == null) {
                    stdErrStream.close();
                    throw throwable4;
                }
                try {
                    stdErrStream.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer safeCreateByteBuffer(byte[] buffer) {
        return ByteBuffer.wrap(buffer == null ? new byte[]{} : buffer);
    }

    private static String getEmrVersion() {
        String defaultValue = "1.0.0";
        String programPath = "/usr/share/aws/emr/util/version";
        File amiVersionProgram = new File(programPath);
        if (amiVersionProgram.exists()) {
            try {
                String result = EmrFsUtils.execCmd(programPath);
                if (!Strings.isNullOrEmpty(result)) {
                    return result;
                }
            }
            catch (Exception e) {
                logger.warn("Unable to retrieve version information, error while executing 'version'", (Throwable)e);
            }
        }
        return defaultValue;
    }

    private static String addAnnotationsIfPresent(String userAgent, Configuration configuration) {
        try {
            if (EmrFsUtils.class.getClassLoader().getResource("emrfs-annotations.properties") == null) {
                return userAgent;
            }
            String annotations = new AnnotationProcessorImpl(configuration).process("emrfs-annotations.properties").toString();
            logger.debug("EMRFS annotations: {}.", (Object)annotations);
            if (StringUtils.isBlank(annotations)) {
                return userAgent;
            }
            return userAgent + " " + annotations;
        }
        catch (Throwable t) {
            logger.error("Adding EmrFs annotations failed.", t);
            return userAgent;
        }
    }

    private static String addFileSystemOwnerInformation(String userAgent, FileSystemOwner fileSystemOwner, Configuration configuration) {
        String fileSystemOwnerInformationFormat = " user:%s,groups:[%s]";
        if (!ConfigurationUtils.isAuthorizationAuditingEnabled(configuration) || fileSystemOwner == null) {
            return userAgent;
        }
        String username = fileSystemOwner.getFullUserName();
        String groups = Joiner.on(',').join(fileSystemOwner.getGroupNames());
        return userAgent + String.format(fileSystemOwnerInformationFormat, username, groups);
    }

    public static String getUserAgent(Configuration configuration) {
        return EmrFsUtils.getUserAgent(null, configuration);
    }

    public static String getUserAgent(FileSystemOwner fileSystemOwner, Configuration configuration) {
        boolean isConsistencyEnabled = ConfigurationUtils.isConsistencyEnabled(configuration);
        String subFsName = isConsistencyEnabled ? "s3c" : "s3n";
        String emrVersion = EmrFsUtils.getEmrVersion().replaceAll("\\s+", "");
        String userAgent = String.format("ElasticMapReduce/%s emrfs/%s", emrVersion, subFsName);
        userAgent = EmrFsUtils.addAnnotationsIfPresent(userAgent, configuration);
        userAgent = EmrFsUtils.addFileSystemOwnerInformation(userAgent, fileSystemOwner, configuration);
        return userAgent;
    }

    public static String makeDestFileKey(String srcDir, String dstDir, String srcFileKey) {
        String suffix = srcFileKey.substring(srcDir.length());
        String dstFileKey = dstDir.charAt(dstDir.length() - 1) != '/' && suffix.charAt(0) != '/' ? dstDir + "/" + suffix : dstDir + suffix;
        return dstFileKey;
    }

    public static AmazonS3Lite getAmazonS3LiteWithRetryPolicy(AmazonS3Lite s3) {
        return EmrFsUtils.getAmazonS3LiteWithRetryPolicy(s3, 5);
    }

    public static AmazonS3Lite getAmazonS3LiteWithRetryPolicy(AmazonS3Lite s3, int maxRetries) {
        return EmrFsUtils.getAmazonS3LiteWithRetryPolicy(s3, maxRetries, 3);
    }

    @VisibleForTesting
    static AmazonS3Lite getAmazonS3LiteWithRetryPolicy(AmazonS3Lite s3, int maxRetries, int sleepTimeInSec) {
        RetryPolicy multipartUploadPolicy = EmrFsUtils.createRetryPolicyForMultipartUploadMethods(maxRetries, sleepTimeInSec);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("completeMultipartUpload", multipartUploadPolicy);
        methodNameToPolicyMap.put("abortMultipartUpload", multipartUploadPolicy);
        methodNameToPolicyMap.put("uploadPart", multipartUploadPolicy);
        return (AmazonS3Lite)RetryProxy.create(AmazonS3Lite.class, (Object)s3, methodNameToPolicyMap);
    }

    private static RetryPolicy createRetryPolicyForMultipartUploadMethods(int maxRetries, int sleepTimeInSec) {
        RetryPolicy basePolicyForAmazonClientExceptions = RetryPolicies.exponentialBackoffRetry((int)maxRetries, (long)sleepTimeInSec, (TimeUnit)TimeUnit.SECONDS);
        return (exception, retries, failovers, isIdempotentOrAtMostOnce) -> {
            if (AmazonServiceExceptions.isAccessDeniedByAmazonService(exception)) {
                return RetryPolicy.RetryAction.FAIL;
            }
            if (exception instanceof AmazonClientException) {
                return basePolicyForAmazonClientExceptions.shouldRetry(exception, retries, failovers, isIdempotentOrAtMostOnce);
            }
            return RetryPolicy.RetryAction.FAIL;
        };
    }

    public static String getJobFlowId() {
        if (Strings.isNullOrEmpty(jobFlowId)) {
            String id = PlatformInfo.forDefaultResourceLocations().getJobFlowId();
            return Strings.isNullOrEmpty(id) ? DEFAULT_JOB_FLOW_ID : id;
        }
        return jobFlowId;
    }

    public static void sleep(long backOffInterval) {
        try {
            Thread.sleep(backOffInterval);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Retry's backoff was interrupted by other process", ie);
        }
    }

    public static List<? extends RequestHandler2> getDefaultRequestHandlers() {
        return ImmutableList.of(new HeadBucketRedirectHandler(BucketRegionStores.inMemoryStore()), new RequestIdLogger());
    }

    private EmrFsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

