/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.Constants;
import com.amazon.ws.emr.hadoop.fs.cse.CSEConstants;
import com.amazon.ws.emr.hadoop.fs.property.AwsS3SignerType;
import com.amazon.ws.emr.hadoop.fs.property.RetryPolicyType;
import com.amazon.ws.emr.hadoop.fs.property.SeekStrategyName;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.Protocol;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.handlers.RequestHandler2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.regions.RegionUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CryptoConfigurationV2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CryptoMode;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CryptoStorageMode;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.SSEAlgorithm;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.StorageClass;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import com.amazon.ws.emr.hadoop.fs.util.AWSRegionUtils;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUtils.class);

    public static boolean isConsistencyEnabled(Configuration configuration) {
        return configuration.getBoolean("fs.s3.consistent", false);
    }

    public static long getDefaultPartSize(Configuration conf) {
        long partSizeConf = conf.getLong("fs.s3n.multipart.uploads.split.size", 0x8000000L);
        if (partSizeConf < 0x500000L) {
            logger.warn("fs.s3n.multipart.uploads.split.size = " + partSizeConf + " is too small, setting to min " + 0x500000L);
            partSizeConf = 0x500000L;
        } else if (partSizeConf > 0x140000000L) {
            logger.warn("fs.s3n.multipart.uploads.split.size = " + partSizeConf + " is too large, setting to max " + 0x140000000L);
            partSizeConf = 0x140000000L;
        }
        return partSizeConf;
    }

    public static double getPartsCompletedThresholdPercent(Configuration conf) {
        double thFractionPartsCompleted = conf.getDouble("fs.s3.multipart.th.fraction.parts.completed", 0.5);
        if (thFractionPartsCompleted <= 0.0 || thFractionPartsCompleted >= 1.0) {
            logger.warn("The value of fs.s3.multipart.th.fraction.parts.completed is not in valid range: (0,1). Will set to default: 0.5");
            thFractionPartsCompleted = 0.5;
        }
        return thFractionPartsCompleted;
    }

    public static double getFractionPartAvgCompletionTime(Configuration conf) {
        double fractionPartAvgCompletionTime = conf.getDouble("fs.s3.multipart.fraction.part.avg.completion.time", 1.0);
        if (fractionPartAvgCompletionTime <= 0.0 || fractionPartAvgCompletionTime > 1.0) {
            logger.warn("The value of fs.s3.multipart.fraction.part.avg.completion.time is not in valid range: (0,1]. Will set to default: 1.0");
            fractionPartAvgCompletionTime = 1.0;
        }
        return fractionPartAvgCompletionTime;
    }

    public static int getPartAttempts(Configuration conf) {
        int partAttempts = conf.getInt("fs.s3.multipart.part.attempts", 5);
        if (partAttempts < 2) {
            logger.warn("The value of fs.s3.multipart.part.attempts is less than min value: 2. Will default to min value.");
            partAttempts = 2;
        }
        return partAttempts;
    }

    public static int getRenameAlgorithmVersion(Configuration conf) {
        int version = conf.getInt("fs.s3.rename.algorithm.version", 1);
        if (version < 1 || version > 2) {
            logger.warn("The value of fs.s3.rename.algorithm.version is not among the acceptable values [1, 2]. Will default to version 1");
            version = 1;
        }
        return version;
    }

    public static long getBlockSize(Configuration conf) {
        return conf.getLong("fs.s3n.block.size", 0x4000000L);
    }

    public static boolean isClientSideEncryptionEnabled(Configuration configuration) {
        return configuration.getBoolean("fs.s3.cse.enabled", false);
    }

    public static boolean isCSEEncryptionV2Enabled(Configuration configuration) {
        return configuration.getBoolean("fs.s3.cse.encryptionV2.enabled", false);
    }

    public static boolean isMultipartUploadEnabled(Configuration configuration) {
        return configuration.getBoolean("fs.s3n.multipart.uploads.enabled", true);
    }

    public static boolean isCreateBucketEnabled(Configuration configuration) {
        return configuration.getBoolean("fs.s3.buckets.create.enabled", false);
    }

    public static String getBucketsCreateRegion(Configuration configuration) {
        return configuration.get("fs.s3.buckets.create.region");
    }

    public static boolean isLazySeekEnabled(Configuration configuration) {
        String seekStrategy = configuration.get("fs.s3.seekStrategy", Constants.FS_S3_SEEK_STRATEGY_DEFAULT);
        SeekStrategyName seekStrategyName = SeekStrategyName.fromName(seekStrategy);
        if (seekStrategyName == null) {
            logger.warn("Invalid strategy specified in {}: {}. Valid strategies are: {}. Will default to {} strategy", new Object[]{"fs.s3.seekStrategy", seekStrategy, SeekStrategyName.getNamesAsString(), Constants.FS_S3_SEEK_STRATEGY_DEFAULT});
            seekStrategyName = SeekStrategyName.LAZY;
        }
        return seekStrategyName.isLazySeekStrategy();
    }

    public static StorageClass getStorageClass(Configuration configuration) {
        String storageClassName = configuration.get("fs.s3.storageClass");
        if (!Strings.isNullOrEmpty(storageClassName)) {
            try {
                StorageClass storageClass = StorageClass.fromValue(storageClassName);
                if (StorageClass.Glacier.equals((Object)storageClass)) {
                    logger.warn("Invalid storage class infs.s3.storageClass: " + storageClassName);
                    return null;
                }
                return storageClass;
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid storage class name in fs.s3.storageClass: " + storageClassName);
            }
        }
        return null;
    }

    public static CannedAccessControlList getAcl(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        String aclName = configuration.get("fs.s3.canned.acl");
        CannedAccessControlList acl = null;
        if (aclName != null) {
            try {
                acl = CannedAccessControlList.valueOf(aclName);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid canned ACL name in fs.s3.canned.acl: " + aclName);
            }
        }
        return acl;
    }

    public static int getMaxConnections(Configuration configuration) {
        return configuration.getInt("fs.s3.maxConnections", 50);
    }

    public static int getMaxRetries(Configuration configuration) {
        return configuration.getInt("fs.s3.maxRetries", 10);
    }

    public static int getRetryPeriodSeconds(Configuration configuration) {
        return configuration.getInt("fs.s3.retryPeriodSeconds", ConfigurationUtils.getConsistencyRetryPeriodSeconds(configuration));
    }

    public static int getConsistencyRetryPeriodSeconds(Configuration configuration) {
        return configuration.getInt("fs.s3.consistent.retryPeriodSeconds", 1);
    }

    public static int getFastFirstRetryPeriodMs(Configuration configuration) {
        int fastFirstRetryDelay = (int)(configuration.getDouble("fs.s3.consistent.fastFirstRetrySeconds", 0.05) * 1000.0);
        Preconditions.checkArgument(fastFirstRetryDelay >= 0, "fs.s3.consistent.fastFirstRetrySeconds must be greater than or equal to 0");
        return fastFirstRetryDelay;
    }

    public static int getConsistencyRetryCount(Configuration configuration) {
        return configuration.getInt("fs.s3.consistent.retryCount", 10);
    }

    public static boolean isThrowingExceptionOnInconsistencyEnabled(Configuration configuration) {
        return configuration.getBoolean("fs.s3.consistent.throwExceptionOnInconsistency", true);
    }

    public static boolean isS3InitialTimeoutEnabled(Configuration configuration) {
        int s3InitialSocketTimeoutMilliSeconds = ConfigurationUtils.getS3InitialSocketTimeoutMillis(configuration);
        return s3InitialSocketTimeoutMilliSeconds < 50000;
    }

    public static int getS3InitialSocketTimeoutMillis(Configuration configuration) {
        int s3InitialSocketTimeoutMilliSeconds = configuration.getInt("fs.s3.getObject.initialSocketTimeoutMilliseconds", 50000);
        if (s3InitialSocketTimeoutMilliSeconds > 50000) {
            logger.warn("S3 getObject initial socket timeout ({} ms) is longer than default socket timeout ({} ms). Ignored.", (Object)s3InitialSocketTimeoutMilliSeconds, (Object)50000);
            return 50000;
        }
        if (s3InitialSocketTimeoutMilliSeconds < 1) {
            logger.warn("S3 getObject initial socket timeout ({} ms) is shorter than minimum socket timeout ({} ms). Using {} ms instead.", new Object[]{s3InitialSocketTimeoutMilliSeconds, 1, 1});
            return 1;
        }
        return s3InitialSocketTimeoutMilliSeconds;
    }

    public static Protocol getProtocol(Configuration configuration) {
        return configuration.getBoolean("fs.s3n.ssl.enabled", true) ? Protocol.HTTPS : Protocol.HTTP;
    }

    public static boolean isServerSideEncryptionEnabled(Configuration configuration) {
        return configuration.getBoolean("fs.s3.enableServerSideEncryption", false);
    }

    public static String getS3SignerType(Configuration configuration) {
        String s3SignerType = configuration.get("fs.s3.signerType");
        if (s3SignerType != null && !AwsS3SignerType.isValidName(s3SignerType)) {
            throw new IllegalArgumentException(String.format("The %s S3 signer type is not supported and current supported types are %s", s3SignerType, StringUtils.join(AwsS3SignerType.getNames(), " ")));
        }
        return s3SignerType;
    }

    public static String getServerSideEncryptionAlgorithm(Configuration configuration) {
        if (!Strings.isNullOrEmpty(ConfigurationUtils.getServerSideEncryptionKmsKeyId(configuration))) {
            return configuration.get("fs.s3.serverSideEncryptionAlgorithm", SSEAlgorithm.KMS.getAlgorithm());
        }
        return configuration.get("fs.s3.serverSideEncryptionAlgorithm", SSEAlgorithm.AES256.getAlgorithm());
    }

    public static String getServerSideEncryptionKmsKeyId(Configuration configuration) {
        return configuration.get("fs.s3.serverSideEncryption.kms.keyId", null);
    }

    public static String getAwsAuthProfile(Configuration configuration) {
        return configuration.get("fs.s3.auth.profile", null);
    }

    public static String getMetadataTableName(Configuration configuration) {
        return configuration.get("fs.s3.consistent.metadata.tableName", "EmrFSMetadata");
    }

    public static long getDefaultReadCapacity(Configuration configuration) {
        return configuration.getLong("fs.s3.consistent.metadata.read.capacity", 500L);
    }

    public static long getDefaultWriteCapacity(Configuration configuration) {
        return configuration.getLong("fs.s3.consistent.metadata.write.capacity", 100L);
    }

    public static boolean isEtagVerificationEnabled(Configuration configuration) {
        return configuration.getBoolean("fs.s3.consistent.metadata.etag.verification.enabled", true);
    }

    public static RetryPolicyType getRetryPolicyType(Configuration configuration) {
        String retryPolicy = configuration.get("fs.s3.consistent.retryPolicyType", Constants.FS_S3_CONSISTENT_RETRY_POLICY_TYPE_DEFAULT);
        RetryPolicyType retryPolicyType = RetryPolicyType.fromName(retryPolicy);
        if (retryPolicyType == null) {
            logger.warn("Invalid retry policy type specified in {}: {}. Valid retry policy types are: {}. Will default to {} retry policy type", new Object[]{"fs.s3.consistent.retryPolicyType", retryPolicy, RetryPolicyType.getNamesAsString(), Constants.FS_S3_CONSISTENT_RETRY_POLICY_TYPE_DEFAULT});
            retryPolicyType = RetryPolicyType.FAST_FIRST_RETRY_EXPONENTIAL;
        }
        return retryPolicyType;
    }

    public static List<Path> getTestedTempPaths(Configuration conf) {
        Object[] s3BufferDirNames = conf.getStrings("fs.s3.buffer.dir");
        ArrayList<Path> tempDirs = new ArrayList<Path>(s3BufferDirNames.length);
        for (String string : s3BufferDirNames) {
            Path s3BufferDirPath = Paths.get(string, new String[0]);
            try {
                Files.createDirectories(s3BufferDirPath, new FileAttribute[0]);
                Files.delete(Files.createTempFile(s3BufferDirPath, "testfile-", ".tmp", new FileAttribute[0]));
                tempDirs.add(s3BufferDirPath);
            }
            catch (Exception logged) {
                logger.warn("Cannot create temp dir with proper permission: {}", (Object)s3BufferDirPath, (Object)logged);
            }
        }
        if (tempDirs.isEmpty()) {
            throw new RuntimeException("Cannot create temp dirs: " + Arrays.toString(s3BufferDirNames));
        }
        return tempDirs;
    }

    public static boolean isDeleteTTLEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3.consistent.metadata.delete.ttl.enabled", true);
    }

    public static Boolean isCSEUnencryptedLengthHeaderMPUEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3.multipart.cse.add.unencrypted.length", false);
    }

    public static boolean isLoadConfigurationEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3.configuration.load.enabled", true);
    }

    public static long getDeleteTTLExpirationLength(Configuration conf) {
        return conf.getLong("fs.s3.consistent.metadata.delete.ttl.expiration.seconds", 2592000L);
    }

    public static EncryptionMaterialsProvider getEncryptionMaterialsProvider(Configuration conf) {
        return (EncryptionMaterialsProvider)ReflectionUtils.newInstance(ConfigurationUtils.getEncryptionMaterialsProviderClass(conf), (Configuration)conf);
    }

    private static Class<? extends EncryptionMaterialsProvider> getEncryptionMaterialsProviderClass(Configuration conf) {
        String className = conf.get("fs.s3.cse.encryptionMaterialsProvider");
        if (Strings.isNullOrEmpty(className)) {
            throw new IllegalArgumentException("EncryptionMaterialsProvider is not specified using fs.s3.cse.encryptionMaterialsProvider");
        }
        try {
            return Class.forName(className).asSubclass(EncryptionMaterialsProvider.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("EncryptionMaterialsProvider not found: " + className, e);
        }
    }

    public static CryptoConfiguration getCryptoConfiguration(Configuration conf) {
        CryptoMode cryptoMode = CryptoMode.valueOf(conf.get("fs.s3.cse.cryptoMode", CSEConstants.CSE_CRYPTO_MODE_DEFAULT));
        CryptoStorageMode storageMode = ConfigurationUtils.getCryptoStorageMode(conf);
        CryptoConfiguration cryptoConfiguration = new CryptoConfiguration().withCryptoMode(cryptoMode).withStorageMode(storageMode);
        String kmsRegion = AWSRegionUtils.getRegion(conf, "fs.s3.cse.kms.region");
        if (!Strings.isNullOrEmpty(kmsRegion)) {
            cryptoConfiguration.setAwsKmsRegion(RegionUtils.getRegion(kmsRegion));
        }
        return cryptoConfiguration;
    }

    public static CryptoConfigurationV2 getCryptoConfigurationV2(Configuration conf) {
        CryptoMode cryptoMode = CryptoMode.valueOf(conf.get("fs.s3.cse.cryptoMode", CSEConstants.CSE_ENCRYPTION_V2_CRYPTO_MODE_DEFAULT));
        CryptoStorageMode storageMode = ConfigurationUtils.getCryptoStorageMode(conf);
        CryptoConfigurationV2 cryptoConfiguration = new CryptoConfigurationV2().withCryptoMode(cryptoMode).withStorageMode(storageMode).withUnsafeUndecryptableObjectPassthrough(cryptoMode != CryptoMode.StrictAuthenticatedEncryption).withRangeGetMode(CSEConstants.CSE_ENCRYPTION_V2_CRYPTO_RANGE_GET_MODE_DEFAULT);
        String kmsRegion = AWSRegionUtils.getRegion(conf, "fs.s3.cse.kms.region");
        if (!Strings.isNullOrEmpty(kmsRegion)) {
            cryptoConfiguration.setAwsKmsRegion(RegionUtils.getRegion(kmsRegion));
        }
        return cryptoConfiguration;
    }

    public static CryptoStorageMode getCryptoStorageMode(Configuration conf) {
        return CryptoStorageMode.valueOf(conf.get("fs.s3.cse.cryptoStorageMode", CSEConstants.CSE_CRYPTO_STORAGE_MODE_DEFAULT));
    }

    public static boolean isAuthorizationAuditingEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3.authorization.audit.enabled", true);
    }

    public static Boolean isUseRequesterPaysHeader(Configuration conf) {
        return conf.getBoolean("fs.s3.useRequesterPaysHeader", false);
    }

    public static long getMetadataCacheExpirationSeconds(Configuration conf) {
        long expirationSeconds = conf.getLong("fs.s3.metadata.cache.expiration.seconds", 60L);
        Preconditions.checkArgument(expirationSeconds >= 0L, "Configured value for %s must not be negative (was: %s)", "fs.s3.metadata.cache.expiration.seconds", expirationSeconds);
        return expirationSeconds;
    }

    public static boolean isPositionedReadOptimizationEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3.positionedRead.optimization.enabled", true);
    }

    public static boolean isListFilesIncrementalFetchEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3.listFiles.incrementalFetch.enabled", true);
    }

    public static boolean includeDescendantsOfFilesForListFilesInOrder(Configuration conf) {
        return conf.getBoolean("fs.s3.listFilesInOrder.includeDescendantsOfFiles", false);
    }

    public static String getListObjectsEncodingType(Configuration conf) {
        return conf.get("fs.s3.listObjects.encodingType");
    }

    public static boolean isLazyInitializeConnection(Configuration conf) {
        return conf.getBoolean("fs.s3.open.lazyConnection.enabled", true);
    }

    public static boolean isUgiGetGroupEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3.authorization.ugi.groupName.enabled", true);
    }

    public static int getS3ThreadPoolSize(Configuration conf) {
        int threadPoolSize = ConfigurationUtils.getS3ThreadPoolCoreSize(conf);
        int threadPoolMaxSize = ConfigurationUtils.getS3ThreadPoolMaxSize(conf);
        if (threadPoolSize <= 0 || threadPoolSize > threadPoolMaxSize) {
            threadPoolSize = 20;
            logger.warn("Thread pool size not in (0, {}], using default {}", (Object)threadPoolMaxSize, (Object)20);
        }
        return threadPoolSize;
    }

    private static int getS3ThreadPoolCoreSize(Configuration conf) {
        return conf.getInt("fs.s3.threadpool.size", 20);
    }

    public static int getS3ThreadPoolMaxSize(Configuration conf) {
        return conf.getInt("fs.s3.threadpool.maxSize", 40);
    }

    public static int getThreadPoolBufferSize(Configuration conf) {
        int threadPoolBufferSize = conf.getInt("fs.s3.threadpool.buffer.size", 10000);
        Preconditions.checkArgument(threadPoolBufferSize >= 0, "Configured value for %s must not be negative (was: %s)", "fs.s3.threadpool.buffer.size", threadPoolBufferSize);
        return threadPoolBufferSize;
    }

    public static int getExternalStagedFilesMaxActiveTasks(Configuration conf) {
        int s3ThreadPoolSize = ConfigurationUtils.getS3ThreadPoolSize(conf);
        int maxActiveTasks = Math.max(1, conf.getInt("fs.s3.externalStagedFiles.maxActiveTasks", s3ThreadPoolSize));
        if (s3ThreadPoolSize <= 1 && maxActiveTasks > 1) {
            logger.warn("Parallel external staged file operations are disabled because they are not supported when thread pool size is 1");
            return 1;
        }
        return maxActiveTasks;
    }

    public static boolean isReadFullyIntoBuffersOptimizationEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3.readFullyIntoBuffers.optimization.enabled", true);
    }

    public static String getSTSEndpointOverride(Configuration conf) {
        if (conf == null) {
            return null;
        }
        String stsEndpoint = conf.get("fs.s3.sts.endpoint");
        if (Strings.isNullOrEmpty(stsEndpoint)) {
            return null;
        }
        return stsEndpoint;
    }

    public static boolean isFastList(Configuration conf) {
        return conf.getBoolean("fs.s3.consistent.fastList", true);
    }

    public static int getFastListBatchSize(Configuration conf) {
        return conf.getInt("fs.s3.consistent.fastList.batchSize", 5000);
    }

    public static int getS3DeleteMaxBatchSize(Configuration conf) {
        int deleteMaxBatchSize = conf.getInt("fs.s3.delete.maxBatchSize", 1000);
        if (deleteMaxBatchSize <= 0 || deleteMaxBatchSize > 1000) {
            logger.warn("Invalid max batch size for delete operations ({}); defaulting to {}", (Object)deleteMaxBatchSize, (Object)1000);
            deleteMaxBatchSize = 1000;
        }
        return deleteMaxBatchSize;
    }

    public static String getS3BucketCreateRegion(Configuration conf) {
        return conf.get("fs.s3.buckets.create.region");
    }

    public static boolean isFileStatusCacheEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3n.filestatuscache.enable", false);
    }

    public static boolean isFolderObjectAutoInsert(Configuration conf) {
        return conf.getBoolean("fs.s3.folderObject.autoInsert", false);
    }

    public static String getCustomAwsCredentialsProvider(Configuration conf) {
        return conf.get("fs.s3.customAWSCredentialsProvider");
    }

    public static boolean isCSEDeletePreviousInstructionFiles(Configuration conf) {
        return conf.getBoolean("fs.s3.cse.cryptoStorageMode.deleteInstructionFiles.enabled", false);
    }

    public static boolean isCSEMaterialsDescriptionEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3.cse.materialsDescription.enabled", false);
    }

    public static boolean isCSEPlaintextLenEnable(Configuration conf) {
        return conf.getBoolean("fs.s3.cse.plaintextLength.enabled", true);
    }

    public static int getSQSPathReportLimit(Configuration conf) {
        return conf.getInt("fs.s3.consistent.notification.SQS.pathReportLimit", 10);
    }

    public static int getSQSBatchSize(Configuration conf) {
        return conf.getInt("fs.s3.consistent.notification.SQS.batchSize", 10);
    }

    public static int getSQSPullWaitTimeSeconds(Configuration conf) {
        return conf.getInt("fs.s3.consistent.notification.SQS.pullWaitTimeSeconds", 3);
    }

    public static boolean isRequestStatisticsEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3.requestStatistics.enabled", false);
    }

    public static boolean isSecretAgentAuthEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3.authorization.secretagent.enabled", false);
    }

    public static List<? extends RequestHandler2> getCustomRequestHandlers(Configuration conf) {
        return conf.getInstances("fs.s3.requestHandler.classNames", RequestHandler2.class);
    }

    private ConfigurationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

