/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.s3.lite.ConnectionErrors;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.ClientConfiguration;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.retry.RetryPolicy;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableSet;
import com.amazon.ws.emr.hadoop.fs.util.AwsClientConfiguration;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientConfigurationFactory {
    private static final Logger logger = LoggerFactory.getLogger(ClientConfigurationFactory.class);
    private static final ImmutableSet<String> ALLOWED_SERVICES = ImmutableSet.of("s3", "dynamodb", "sts");
    private final Configuration configuration;
    private final FileSystemOwner fileSystemOwner;
    private final AwsClientConfiguration awsClientConfiguration;

    public ClientConfigurationFactory(Configuration configuration) {
        this(null, configuration, null);
    }

    public ClientConfigurationFactory(FileSystemOwner fileSystemOwner, Configuration configuration, AwsClientConfiguration awsClientConfiguration) {
        this.fileSystemOwner = fileSystemOwner;
        this.configuration = configuration == null ? null : new Configuration(configuration);
        this.awsClientConfiguration = awsClientConfiguration;
    }

    public ClientConfigurationFactory(AwsClientConfiguration proxyConfiguration) {
        this(null, null, proxyConfiguration);
    }

    public ClientConfiguration getClientConfiguration(String service) {
        return this.getClientConfiguration(service, null);
    }

    public ClientConfiguration getClientConfiguration(String service, RetryPolicy retryPolicy) {
        Preconditions.checkArgument(ALLOWED_SERVICES.contains(service), "Service: %s is not allowed to be used, allowed services: %s", service, ALLOWED_SERVICES);
        ClientConfiguration clientConfiguration = this.getDefaultClientConfiguration(service);
        if (retryPolicy != null) {
            clientConfiguration.setRetryPolicy(retryPolicy);
        } else if ("dynamodb".equals(service)) {
            clientConfiguration.setRetryPolicy(PredefinedRetryPolicies.getDynamoDBDefaultRetryPolicy());
        }
        if (this.awsClientConfiguration != null) {
            clientConfiguration.setProxyDomain(this.awsClientConfiguration.getProxyDomain());
            clientConfiguration.setProxyHost(this.awsClientConfiguration.getProxyHost());
            clientConfiguration.setProxyPassword(this.awsClientConfiguration.getProxyPassword());
            clientConfiguration.setProxyUsername(this.awsClientConfiguration.getProxyUsername());
            clientConfiguration.setProxyWorkstation(this.awsClientConfiguration.getProxyWorkstation());
            clientConfiguration.setProxyPort(this.awsClientConfiguration.getProxyPort());
            clientConfiguration.setNonProxyHosts(this.awsClientConfiguration.getNonProxyHosts());
        }
        return clientConfiguration;
    }

    public ClientConfiguration getClientConfigurationInitialTimeoutOnlyIfSet(String service, RetryPolicy retryPolicy) {
        if ("s3".equalsIgnoreCase(service) && ConfigurationUtils.isS3InitialTimeoutEnabled(this.configuration)) {
            int s3InitialSocketTimeoutMillis = ConfigurationUtils.getS3InitialSocketTimeoutMillis(this.configuration);
            logger.info("Set initial getObject socket timeout to {} ms.", (Object)s3InitialSocketTimeoutMillis);
            ClientConfiguration clientConfiguration = this.getClientConfiguration(service, retryPolicy);
            clientConfiguration.withSocketTimeout(s3InitialSocketTimeoutMillis).withRetryPolicy(this.getInitialTimeoutRetryPolicy(retryPolicy));
            return clientConfiguration;
        }
        return null;
    }

    private RetryPolicy getInitialTimeoutRetryPolicy(RetryPolicy retryPolicy) {
        RetryPolicy defaultPolicy = retryPolicy != null ? retryPolicy : ClientConfiguration.DEFAULT_RETRY_POLICY;
        RetryPolicy.RetryCondition defaultCondition = defaultPolicy.getRetryCondition();
        RetryPolicy.RetryCondition customCondition = (originalRequest, exception, retriesAttempted) -> !ConnectionErrors.isCausedByInterruptedIOException(exception) && defaultCondition.shouldRetry(originalRequest, exception, retriesAttempted);
        return new RetryPolicy(customCondition, defaultPolicy.getBackoffStrategy(), defaultPolicy.getMaxErrorRetry(), defaultPolicy.isMaxErrorRetryInClientConfigHonored());
    }

    private ClientConfiguration getDefaultClientConfiguration(String serviceName) {
        String s3SignerType;
        if (this.configuration == null) {
            return new ClientConfiguration();
        }
        int maxRetries = ConfigurationUtils.getMaxRetries(this.configuration);
        int maxConnections = ConfigurationUtils.getMaxConnections(this.configuration);
        String userAgent = EmrFsUtils.getUserAgent(this.fileSystemOwner, this.configuration);
        ClientConfiguration clientConfig = new ClientConfiguration().withMaxErrorRetry(maxRetries).withUserAgent(userAgent).withMaxConnections(maxConnections).withProtocol(ConfigurationUtils.getProtocol(this.configuration));
        if ("s3".equals(serviceName) && (s3SignerType = this.getS3SignerType()) != null) {
            clientConfig.setSignerOverride(s3SignerType);
        }
        logger.debug("Setting {} max connections to: {}", (Object)serviceName, (Object)maxConnections);
        logger.debug("Using user agent: {}", (Object)userAgent);
        return clientConfig;
    }

    private String getS3SignerType() {
        return ConfigurationUtils.getS3SignerType(this.configuration);
    }
}

