/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.ClientConfiguration;
import com.amazon.ws.emr.hadoop.fs.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.amazon.ws.emr.hadoop.fs.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import java.util.Objects;

public final class AwsClientConfiguration {
    private final String proxyDomain;
    private final String proxyHost;
    private final String proxyPassword;
    private final int proxyPort;
    private final String proxyUsername;
    private final String proxyWorkstation;
    private final String nonProxyHosts;

    @JsonCreator
    public AwsClientConfiguration(@JsonProperty(value="proxyDomain") String proxyDomain, @JsonProperty(value="proxyHost") String proxyHost, @JsonProperty(value="proxyPassword") String proxyPassword, @JsonProperty(value="proxyPort") int proxyPort, @JsonProperty(value="proxyUsername") String proxyUsername, @JsonProperty(value="proxyWorkstation") String proxyWorkstation, @JsonProperty(value="nonProxyHosts") String nonProxyHosts) {
        this.proxyDomain = proxyDomain;
        this.proxyHost = proxyHost;
        this.proxyPassword = proxyPassword;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyWorkstation = proxyWorkstation;
        this.nonProxyHosts = nonProxyHosts;
    }

    public AwsClientConfiguration(ClientConfiguration clientConfiguration) {
        Objects.requireNonNull(clientConfiguration, "Client Configuration should not be null");
        this.proxyDomain = clientConfiguration.getProxyDomain();
        this.proxyHost = clientConfiguration.getProxyHost();
        this.proxyPassword = clientConfiguration.getProxyPassword();
        this.proxyPort = clientConfiguration.getProxyPort();
        this.proxyUsername = clientConfiguration.getProxyUsername();
        this.proxyWorkstation = clientConfiguration.getProxyWorkstation();
        this.nonProxyHosts = clientConfiguration.getNonProxyHosts();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.proxyHost).append(this.proxyDomain).append(this.proxyUsername).append(this.proxyPassword).append(this.proxyWorkstation).append(this.proxyPort).append(this.nonProxyHosts).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AwsClientConfiguration rhs = (AwsClientConfiguration)obj;
        return new EqualsBuilder().append(this.proxyHost, rhs.proxyHost).append(this.proxyDomain, rhs.proxyDomain).append(this.proxyUsername, rhs.proxyUsername).append(this.proxyPassword, rhs.proxyPassword).append(this.proxyWorkstation, rhs.proxyWorkstation).append(this.proxyPort, rhs.proxyPort).append(this.nonProxyHosts, rhs.nonProxyHosts).isEquals();
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }
}

