/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.cache.Cache;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.cache.CacheBuilder;
import com.amazon.ws.emr.hadoop.fs.sts.DefaultSTSClientBuilder;
import com.amazon.ws.emr.hadoop.fs.util.AwsClientConfiguration;
import com.amazon.ws.emr.hadoop.fs.util.UserData;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AWSSessionCredentialsProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(AWSSessionCredentialsProviderFactory.class);
    @VisibleForTesting
    public static final String EMRFS_SESSION = "EmrFS-Session";
    private static final Cache<String, AWSSessionCredentialsProvider> PROVIDERS_CACHE = CacheBuilder.newBuilder().maximumSize(100L).initialCapacity(10).concurrencyLevel(10).build();

    @Nullable
    public static AWSSessionCredentialsProvider getCredentialsProviderForRoleArn(String roleArn, Configuration configuration) {
        if (roleArn == null) {
            return null;
        }
        AWSSessionCredentialsProvider cachedProvider = null;
        try {
            cachedProvider = PROVIDERS_CACHE.get(roleArn, () -> AWSSessionCredentialsProviderFactory.createCredentialsProviderForRoleArn(roleArn, configuration));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return cachedProvider;
    }

    private static AWSSessionCredentialsProvider createCredentialsProviderForRoleArn(String roleArn, Configuration configuration) {
        Optional<AwsClientConfiguration> awsClientConfiguration = UserData.ofDefaultResourceLocations().getInstanceAwsClientConfiguration();
        AWSSecurityTokenService stsClient = DefaultSTSClientBuilder.defaultClient(awsClientConfiguration, configuration);
        return new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, EMRFS_SESSION).withStsClient(stsClient).build();
    }

    private AWSSessionCredentialsProviderFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

