/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.regions.Region;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.regions.RegionUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.regions.Regions;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AWSRegionUtils {
    private static final Logger logger = LoggerFactory.getLogger(AWSRegionUtils.class);

    public static String getRegion(Configuration configuration, String regionConf) {
        if (regionConf != null && configuration != null && configuration.get(regionConf) != null) {
            return configuration.get(regionConf);
        }
        if (Regions.getCurrentRegion() != null) {
            return Regions.getCurrentRegion().getName();
        }
        logger.warn("Cannot get region info from Ec2 metadata, using us-east-1 for desktop.");
        return Regions.US_EAST_1.getName();
    }

    public static Region getRegion() {
        Region region = Regions.getCurrentRegion();
        if (region == null) {
            logger.info("Unable to get region id from EC2 metadata. Defaulting to us-east-1");
            region = RegionUtils.getRegion(Regions.US_EAST_1.getName());
        }
        return region;
    }

    private AWSRegionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

