/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.regions.Region;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.regions.Regions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableMap;
import com.amazon.ws.emr.hadoop.fs.util.AWSRegionUtils;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AWSEndpointUtils {
    private static final Logger logger = LoggerFactory.getLogger(AWSEndpointUtils.class);
    private static final Map<Region, String> REGION_ENDPOINT_OVERRIDES = ImmutableMap.of(Region.getRegion(Regions.GovCloud), "s3-fips-us-gov-west-1.amazonaws.com");

    public static String getEndpoint(String service, Configuration config) {
        String endpoint;
        switch (service) {
            case "s3": {
                endpoint = AWSEndpointUtils.getS3Endpoint(config);
                break;
            }
            case "dynamodb": {
                endpoint = AWSEndpointUtils.getDynamoDbEndpoint(config);
                break;
            }
            default: {
                endpoint = AWSEndpointUtils.getEndpoint(service, AWSRegionUtils.getRegion());
            }
        }
        logger.debug("Using endpoint {} for service {}.", (Object)endpoint, (Object)service);
        return endpoint;
    }

    static String getEndpoint(String service, Region region) {
        return region.getServiceEndpoint(service);
    }

    public static String getDynamoDbEndpoint(Configuration config) {
        String configuredEndpoint = config.get("fs.s3.consistent.dynamodb.endpoint");
        if (configuredEndpoint != null) {
            return configuredEndpoint;
        }
        return AWSEndpointUtils.getEndpoint("dynamodb", AWSRegionUtils.getRegion());
    }

    public static String getS3Endpoint(Configuration config) {
        String configuredEndpoint = config.get("fs.s3n.endpoint");
        if (configuredEndpoint != null) {
            return configuredEndpoint;
        }
        return AWSEndpointUtils.getS3Endpoint(AWSRegionUtils.getRegion());
    }

    public static String getS3Endpoint(Region region) {
        String endpoint = REGION_ENDPOINT_OVERRIDES.get(region);
        if (endpoint != null) {
            return endpoint;
        }
        return AWSEndpointUtils.getEndpoint("s3", region);
    }

    public static String getS3Endpoint(Regions region) {
        return AWSEndpointUtils.getS3Endpoint(Region.getRegion(region));
    }

    private AWSEndpointUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

