/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.sts;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.ClientConfiguration;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.client.builder.AwsClientBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.regions.Region;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazon.ws.emr.hadoop.fs.util.AWSRegionUtils;
import com.amazon.ws.emr.hadoop.fs.util.AwsClientConfiguration;
import com.amazon.ws.emr.hadoop.fs.util.ClientConfigurationFactory;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSTSClientBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSTSClientBuilder.class);

    public static AWSSecurityTokenService defaultClient(Optional<AwsClientConfiguration> awsClientConfiguration, Configuration conf) {
        AWSSecurityTokenServiceClientBuilder builder = AWSSecurityTokenServiceClientBuilder.standard();
        String stsEndpointOverride = ConfigurationUtils.getSTSEndpointOverride(conf);
        if (stsEndpointOverride == null) {
            logger.debug("Using sts regional stsEndpointOverride");
            builder.withEndpointConfiguration(DefaultSTSClientBuilder.getSTSRegionalEndpointConfiguration());
        } else {
            logger.debug("Using sts stsEndpointOverride override {}", (Object)stsEndpointOverride);
        }
        if (awsClientConfiguration.isPresent()) {
            ClientConfiguration clientConfiguration = new ClientConfigurationFactory(awsClientConfiguration.get()).getClientConfiguration("sts");
            builder.withClientConfiguration(clientConfiguration);
        }
        return (AWSSecurityTokenService)builder.build();
    }

    private static AwsClientBuilder.EndpointConfiguration getSTSRegionalEndpointConfiguration() {
        Region region = AWSRegionUtils.getRegion();
        return new AwsClientBuilder.EndpointConfiguration(region.getServiceEndpoint("sts"), region.getName());
    }

    private DefaultSTSClientBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

