/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.path;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPathConverter;
import com.amazon.ws.emr.hadoop.fs.util.HadoopPaths;
import lombok.NonNull;
import org.apache.hadoop.fs.Path;

public final class StagingRoot {
    private final Path outputPath;
    private final String stageName;

    public static StagingRoot of(@NonNull Path outputPath, @NonNull String stageName) {
        if (outputPath == null) {
            throw new NullPointerException("outputPath is marked non-null but is null");
        }
        if (stageName == null) {
            throw new NullPointerException("stageName is marked non-null but is null");
        }
        Preconditions.checkArgument(HadoopPaths.isFullyQualified(outputPath), "OutputPath (%s) must be fully qualified", outputPath);
        Preconditions.checkArgument(!stageName.isEmpty(), "StageName must not be empty");
        return new StagingRoot(outputPath, stageName);
    }

    public String toString() {
        return StagingPathConverter.defaultConverter().toHadoopPath(this).toString();
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    public String getStageName() {
        return this.stageName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StagingRoot)) {
            return false;
        }
        StagingRoot other = (StagingRoot)o;
        Path this$outputPath = this.getOutputPath();
        Path other$outputPath = other.getOutputPath();
        if (this$outputPath == null ? other$outputPath != null : !this$outputPath.equals(other$outputPath)) {
            return false;
        }
        String this$stageName = this.getStageName();
        String other$stageName = other.getStageName();
        return !(this$stageName == null ? other$stageName != null : !this$stageName.equals(other$stageName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $outputPath = this.getOutputPath();
        result = result * 59 + ($outputPath == null ? 43 : $outputPath.hashCode());
        String $stageName = this.getStageName();
        result = result * 59 + ($stageName == null ? 43 : $stageName.hashCode());
        return result;
    }

    private StagingRoot(Path outputPath, String stageName) {
        this.outputPath = outputPath;
        this.stageName = stageName;
    }
}

