/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.path;

import com.amazon.ws.emr.hadoop.fs.util.HadoopPaths;
import com.amazon.ws.emr.hadoop.fs.util.MoreIterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.fs.Path;

public final class PathOverlapChecker {
    private final Node pathTreeRoot = new Node(NodeConstraint.NONE);

    public synchronized void checkAndAddPath(Path path) throws IllegalArgumentException {
        Iterator<String> componentIterator = MoreIterators.prepend("", HadoopPaths.getComponentsOfAbsolutePath(path).iterator());
        Node currentNode = this.pathTreeRoot;
        while (componentIterator.hasNext()) {
            boolean isLastComponent;
            String component = componentIterator.next();
            boolean bl = isLastComponent = !componentIterator.hasNext();
            if (isLastComponent) {
                boolean wasAdded = currentNode.addChild(component, NodeConstraint.MUST_BE_LEAF);
                if (wasAdded) continue;
                throw this.newPathOverlappedException(path);
            }
            currentNode = currentNode.tryGettingOrAddingChild(component).orElseThrow(() -> this.newPathOverlappedException(path));
        }
    }

    private IllegalArgumentException newPathOverlappedException(Path path) {
        return new IllegalArgumentException(String.format("Path %s overlaps with existing path(s)", path));
    }

    private static enum NodeConstraint {
        MUST_BE_LEAF,
        NONE;

    }

    private static class Node {
        private final NodeConstraint nodeConstraint;
        private final Map<String, Node> children;

        Node(NodeConstraint nodeConstraint) {
            this.nodeConstraint = nodeConstraint;
            this.children = nodeConstraint == NodeConstraint.MUST_BE_LEAF ? null : new HashMap();
        }

        boolean addChild(String component, NodeConstraint nodeConstraint) {
            if (this.nodeConstraint == NodeConstraint.MUST_BE_LEAF) {
                return false;
            }
            if (this.children.containsKey(component)) {
                return false;
            }
            Node newNode = new Node(nodeConstraint);
            this.children.put(component, newNode);
            return true;
        }

        Optional<Node> tryGettingOrAddingChild(String component) {
            return this.nodeConstraint == NodeConstraint.MUST_BE_LEAF ? Optional.empty() : Optional.of(this.children.computeIfAbsent(component, key -> new Node(NodeConstraint.NONE)));
        }
    }
}

