/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.MultipartUploadDispatcher;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.staging.DeferredUpload;
import com.amazon.ws.emr.hadoop.fs.staging.DeferredUploadStatistics;
import com.amazon.ws.emr.hadoop.fs.staging.MultipartUploadEvents;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.EmrStagedFileMetadata;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagedFileHandle;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagingStatus;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.UploadMetadata;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory.DeletedStagingDirectoryException;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory.Key;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory.StagingDirectory;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory.StateAwareStagedFileHandle;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPath;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingRoot;
import com.amazon.ws.emr.hadoop.fs.util.ExceptionCollector;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Clock;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import lombok.NonNull;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.staging.StagedFileMetadata;
import org.apache.hadoop.fs.staging.StagingDirectoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InMemoryStagingDirectory
implements StagingDirectory {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryStagingDirectory.class);
    private NavigableMap<Key, DeferredUpload> deferredUploads = new TreeMap<Key, DeferredUpload>();
    private State state = State.INITIALIZED;
    @NonNull
    private final StagingRoot root;
    @NonNull
    private final MultipartUploadDispatcher uploadDispatcher;
    @NonNull
    private final Clock clock;
    @NonNull
    private final DeferredUploadStatistics stats;

    InMemoryStagingDirectory(StagingRoot root, MultipartUploadDispatcher uploadDispatcher) {
        this(root, uploadDispatcher, Clock.systemDefaultZone(), new DeferredUploadStatistics(root));
    }

    @Override
    public StagedFileHandle createFile(@NonNull List<String> pathComponents, boolean overwrite) throws IOException {
        if (pathComponents == null) {
            throw new NullPointerException("pathComponents is marked non-null but is null");
        }
        Preconditions.checkArgument(!pathComponents.isEmpty(), "Cannot create a file at the root of a staging directory (%s)", this.root);
        this.checkStateIsInitialized();
        Key key = Key.of(pathComponents);
        if (!overwrite && this.exists(key)) {
            throw new FileAlreadyExistsException(String.format("File or directory already exists at '%s'", this.getQualifiedPathString(key)));
        }
        return new StateAwareStagedFileHandle(new InternalFileHandle(key));
    }

    @Override
    public StagingStatus getStatus(@NonNull List<String> pathComponents) throws IOException {
        if (pathComponents == null) {
            throw new NullPointerException("pathComponents is marked non-null but is null");
        }
        this.checkStateIsInitialized();
        StagingPath path = StagingPath.of(this.root, pathComponents);
        if (path.isRoot()) {
            return StagingStatus.forDirectory(path);
        }
        Key key = Key.of(pathComponents);
        DeferredUpload upload = (DeferredUpload)this.deferredUploads.get(key);
        if (upload != null) {
            return this.newStatusForFile(path, upload);
        }
        if (this.containsKeyAsPrefixOfAnotherKey(key)) {
            return StagingStatus.forDirectory(path);
        }
        throw new FileNotFoundException(String.format("No such file or directory at '%s'", path));
    }

    @Override
    public void publish() throws IOException {
        this.checkStateIsInitialized();
        Iterator iterator = this.deferredUploads.entrySet().iterator();
        boolean completedAnyUploads = false;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DeferredUpload upload = (DeferredUpload)entry.getValue();
            if (!upload.isCompleted()) {
                this.completeUpload((Key)entry.getKey(), upload);
                completedAnyUploads = true;
            }
            iterator.remove();
        }
        if (completedAnyUploads) {
            this.stats.log();
        }
    }

    @Override
    public Iterator<StagedFileMetadata> export() throws IOException {
        this.checkStateIsInitialized();
        this.state = State.EXPORTED;
        final NavigableMap<Key, DeferredUpload> uploads = this.deferredUploads;
        this.deferredUploads = null;
        return new Iterator<StagedFileMetadata>(){
            Iterator<Map.Entry<Key, DeferredUpload>> uploadIterator;
            {
                this.uploadIterator = uploads.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.uploadIterator.hasNext();
            }

            @Override
            public StagedFileMetadata next() {
                Map.Entry<Key, DeferredUpload> entry = this.uploadIterator.next();
                this.uploadIterator.remove();
                return EmrStagedFileMetadata.of(InMemoryStagingDirectory.this.getOutputPath(entry.getKey()), entry.getValue().getMetadata());
            }
        };
    }

    @Override
    public void delete() throws IOException {
        if (State.DELETED.equals((Object)this.state) || State.EXPORTED.equals((Object)this.state)) {
            return;
        }
        this.state = State.DELETED;
        ExceptionCollector exceptionCollector = new ExceptionCollector();
        try {
            this.abortDeferredUploads(exceptionCollector);
        }
        catch (RuntimeException e) {
            exceptionCollector.add(e);
        }
        finally {
            exceptionCollector.throwIfNotEmpty(() -> new IOException(String.format("Failed aborting one or more deferred uploads under staging directory at '%s'", this.root)));
        }
    }

    private void checkStateIsInitialized() throws StagingDirectoryNotFoundException {
        this.checkNotDeleted();
        this.checkNotExported();
    }

    private void checkNotDeleted() throws DeletedStagingDirectoryException {
        if (State.DELETED.equals((Object)this.state)) {
            throw new DeletedStagingDirectoryException(this.root);
        }
    }

    private void checkNotExported() throws StagingDirectoryNotFoundException {
        if (State.EXPORTED.equals((Object)this.state)) {
            throw new StagingDirectoryNotFoundException(this.root.getOutputPath(), this.root.getStageName(), "was exported");
        }
    }

    private boolean exists(Key key) {
        return this.deferredUploads.containsKey(key) || this.containsKeyAsPrefixOfAnotherKey(key);
    }

    private boolean containsKeyAsPrefixOfAnotherKey(Key key) {
        Key higherKey = this.deferredUploads.higherKey(key);
        return higherKey != null && higherKey.startsWith(key);
    }

    private String getQualifiedPathString(Key key) {
        return this.root + "/" + key;
    }

    private StagingStatus newStatusForFile(StagingPath path, DeferredUpload upload) {
        long length = upload.getMetadata().getTotalLength();
        long modificationTime = upload.getDeferralTime();
        return StagingStatus.forFile(path, length, modificationTime);
    }

    private DeferredUpload newDeferredUpload(UploadMetadata uploadMetadata) {
        long deferralTime = this.clock.millis();
        return new DeferredUpload(uploadMetadata, deferralTime);
    }

    private void abortDeferredUploads(ExceptionCollector exceptionCollector) {
        Iterator iterator = this.deferredUploads.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                this.abortUpload((Key)entry.getKey(), ((DeferredUpload)entry.getValue()).getMetadata());
            }
            catch (IOException | RuntimeException e) {
                logger.warn("Failed aborting deferred upload of '{}' under staging directory at '{}'", new Object[]{this.getOutputPath((Key)entry.getKey()), this.root, e});
                exceptionCollector.add(e);
            }
            iterator.remove();
        }
    }

    private void completeUpload(Key key, DeferredUpload upload) throws IOException {
        UploadMetadata uploadMetadata = upload.getMetadata();
        this.uploadDispatcher.complete(MultipartUploadEvents.createCompleteEvent(this.getBucket(), this.toOutputS3Key(key), uploadMetadata));
        upload.setCompletedTime(this.clock.millis());
        this.stats.addCompletedUpload(upload);
        logger.info("Completed deferred upload of '{}' under staging directory at '{}'", (Object)this.getOutputPath(key), (Object)this.root);
    }

    private void abortUpload(Key key, UploadMetadata uploadMetadata) throws IOException {
        this.uploadDispatcher.abort(MultipartUploadEvents.createAbortEvent(this.getBucket(), this.toOutputS3Key(key), uploadMetadata));
        logger.info("Aborted deferred upload of '{}' under staging directory at '{}'", (Object)this.getOutputPath(key), (Object)this.root);
    }

    private String getBucket() {
        return this.root.getOutputPath().toUri().getAuthority();
    }

    private String toOutputS3Key(Key key) {
        return S3UriUtils.pathToKey(this.getOutputPath(key));
    }

    private Path getOutputPath(Key key) {
        return new Path(this.root.getOutputPath(), key.toString());
    }

    public InMemoryStagingDirectory(@NonNull StagingRoot root, @NonNull MultipartUploadDispatcher uploadDispatcher, @NonNull Clock clock, @NonNull DeferredUploadStatistics stats) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (uploadDispatcher == null) {
            throw new NullPointerException("uploadDispatcher is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        if (stats == null) {
            throw new NullPointerException("stats is marked non-null but is null");
        }
        this.root = root;
        this.uploadDispatcher = uploadDispatcher;
        this.clock = clock;
        this.stats = stats;
    }

    private static enum State {
        INITIALIZED,
        DELETED,
        EXPORTED;

    }

    private final class InternalFileHandle
    implements StagedFileHandle {
        private final Key key;

        @Override
        public void complete(@NonNull UploadMetadata uploadMetadata) throws IOException {
            if (uploadMetadata == null) {
                throw new NullPointerException("uploadMetadata is marked non-null but is null");
            }
            InMemoryStagingDirectory.this.checkStateIsInitialized();
            DeferredUpload previousUpload = InMemoryStagingDirectory.this.deferredUploads.put(this.key, InMemoryStagingDirectory.this.newDeferredUpload(uploadMetadata));
            if (previousUpload != null && !previousUpload.getMetadata().getUploadId().equals(uploadMetadata.getUploadId())) {
                this.abortPreviousUpload(previousUpload);
            }
        }

        public String toString() {
            return String.format("Handle for '%s'", InMemoryStagingDirectory.this.getQualifiedPathString(this.key));
        }

        private void abortPreviousUpload(DeferredUpload upload) {
            try {
                InMemoryStagingDirectory.this.abortUpload(this.key, upload.getMetadata());
            }
            catch (IOException e) {
                logger.error("Failed to abort the previous deferred upload for '{}'", (Object)InMemoryStagingDirectory.this.getQualifiedPathString(this.key), (Object)e);
            }
        }

        public InternalFileHandle(Key key) {
            this.key = key;
        }
    }
}

