/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.metadata;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PartETag;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.EmrPartETag;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class UploadMetadata
implements Externalizable {
    String uploadId;
    EmrPartETag[] emrPartETags;
    long totalLength;

    public UploadMetadata() {
    }

    public static UploadMetadata of(@NonNull String uploadId, @NonNull List<PartETag> partETags, long totalLength) {
        if (uploadId == null) {
            throw new NullPointerException("uploadId is marked non-null but is null");
        }
        if (partETags == null) {
            throw new NullPointerException("partETags is marked non-null but is null");
        }
        Preconditions.checkArgument(totalLength >= 0L, "TotalLength must not be negative");
        EmrPartETag[] emrPartETags = (EmrPartETag[])partETags.stream().map(EmrPartETag::of).toArray(EmrPartETag[]::new);
        return new UploadMetadata(uploadId, emrPartETags, totalLength);
    }

    public List<PartETag> getPartETags() {
        return Arrays.stream(this.emrPartETags).map(EmrPartETag::toPartETag).collect(Collectors.toList());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.uploadId);
        out.writeInt(this.emrPartETags.length);
        for (EmrPartETag partETag : this.emrPartETags) {
            out.writeObject(partETag);
        }
        out.writeLong(this.totalLength);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.uploadId = in.readUTF();
        int totalParts = in.readInt();
        this.emrPartETags = new EmrPartETag[totalParts];
        for (int readParts = 0; readParts < totalParts; ++readParts) {
            this.emrPartETags[readParts] = (EmrPartETag)in.readObject();
        }
        this.totalLength = in.readLong();
        this.validateReadExternalResult();
    }

    private void validateReadExternalResult() throws InvalidObjectException {
        if (this.uploadId == null) {
            throw new InvalidObjectException("No uploadId in deserialized UploadMetadata");
        }
        if (this.emrPartETags == null) {
            throw new InvalidObjectException("No partETags in deserialized UploadMetadata");
        }
        if (Arrays.asList(this.emrPartETags).contains(null)) {
            throw new InvalidObjectException("PartEtags in deserialized UploadMetadata contains null");
        }
        if (this.totalLength < 0L) {
            throw new InvalidObjectException("Negative totalLength in deserialized UploadMetadata");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadMetadata)) {
            return false;
        }
        UploadMetadata other = (UploadMetadata)o;
        String this$uploadId = this.getUploadId();
        String other$uploadId = other.getUploadId();
        if (this$uploadId == null ? other$uploadId != null : !this$uploadId.equals(other$uploadId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.emrPartETags, other.emrPartETags)) {
            return false;
        }
        return this.getTotalLength() == other.getTotalLength();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uploadId = this.getUploadId();
        result = result * 59 + ($uploadId == null ? 43 : $uploadId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.emrPartETags);
        long $totalLength = this.getTotalLength();
        result = result * 59 + (int)($totalLength >>> 32 ^ $totalLength);
        return result;
    }

    public String toString() {
        return "UploadMetadata(uploadId=" + this.getUploadId() + ", emrPartETags=" + Arrays.deepToString(this.emrPartETags) + ", totalLength=" + this.getTotalLength() + ")";
    }

    private UploadMetadata(String uploadId, EmrPartETag[] emrPartETags, long totalLength) {
        this.uploadId = uploadId;
        this.emrPartETags = emrPartETags;
        this.totalLength = totalLength;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public long getTotalLength() {
        return this.totalLength;
    }
}

