/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.metadata;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.SerializationException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.SerializationUtils;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.UploadMetadata;
import java.io.Serializable;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.staging.StagedFileMetadata;

public final class EmrStagedFileMetadata
extends StagedFileMetadata {
    private static final long serialVersionUID = 1L;

    @VisibleForTesting
    EmrStagedFileMetadata(@Nonnull Path destinationPath, @Nonnull Serializable stagingMetadata) {
        super(destinationPath, stagingMetadata);
    }

    public static EmrStagedFileMetadata of(@NonNull Path destinationPath, @NonNull UploadMetadata uploadMetadata) throws SerializationException {
        if (destinationPath == null) {
            throw new NullPointerException("destinationPath is marked non-null but is null");
        }
        if (uploadMetadata == null) {
            throw new NullPointerException("uploadMetadata is marked non-null but is null");
        }
        return new EmrStagedFileMetadata(destinationPath, (Serializable)SerializationUtils.serialize(uploadMetadata));
    }

    protected String getStagingMetadataString() {
        try {
            return SerializationUtils.deserialize((byte[])this.getStagingMetadata()).toString();
        }
        catch (RuntimeException re) {
            return super.getStagingMetadataString();
        }
    }
}

