/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.metadata;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PartETag;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class EmrPartETag
implements Externalizable {
    private int partNumber;
    @NonNull
    private String etag;

    public EmrPartETag() {
    }

    public static EmrPartETag of(PartETag partETag) {
        return new EmrPartETag(partETag.getPartNumber(), partETag.getETag());
    }

    PartETag toPartETag() {
        return new PartETag(this.partNumber, this.etag);
    }

    public static List<EmrPartETag> fromPartETags(List<PartETag> partETags) {
        return partETags.stream().map(EmrPartETag::of).collect(Collectors.toList());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.partNumber);
        out.writeUTF(this.etag);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.partNumber = in.readInt();
        this.etag = in.readUTF();
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    @NonNull
    public String getEtag() {
        return this.etag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmrPartETag)) {
            return false;
        }
        EmrPartETag other = (EmrPartETag)o;
        if (this.getPartNumber() != other.getPartNumber()) {
            return false;
        }
        String this$etag = this.getEtag();
        String other$etag = other.getEtag();
        return !(this$etag == null ? other$etag != null : !this$etag.equals(other$etag));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartNumber();
        String $etag = this.getEtag();
        result = result * 59 + ($etag == null ? 43 : $etag.hashCode());
        return result;
    }

    public String toString() {
        return "EmrPartETag(partNumber=" + this.getPartNumber() + ", etag=" + this.getEtag() + ")";
    }

    private EmrPartETag(int partNumber, @NonNull String etag) {
        if (etag == null) {
            throw new NullPointerException("etag is marked non-null but is null");
        }
        this.partNumber = partNumber;
        this.etag = etag;
    }
}

