/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging;

import com.amazon.ws.emr.hadoop.fs.util.io.IORunnable;
import java.io.IOException;
import java.util.function.Function;

public interface Task {
    public boolean isBlockingTask();

    public void run() throws IOException;

    default public boolean abandonRemainingTasks(Throwable throwable) {
        return false;
    }

    public static Task newBlockingTask(final IORunnable ioRunnable) {
        return new Task(){

            @Override
            public boolean isBlockingTask() {
                return true;
            }

            @Override
            public void run() throws IOException {
                ioRunnable.run();
            }
        };
    }

    public static Task newNonBlockingTask(IORunnable ioRunnable) {
        return Task.newNonBlockingTask(ioRunnable, throwable -> false);
    }

    public static Task newNonBlockingTask(final IORunnable ioRunnable, final Function<Throwable, Boolean> shouldAbandonRemainingTasks) {
        return new Task(){

            @Override
            public boolean isBlockingTask() {
                return false;
            }

            @Override
            public void run() throws IOException {
                ioRunnable.run();
            }

            @Override
            public boolean abandonRemainingTasks(Throwable throwable) {
                return (Boolean)shouldAbandonRemainingTasks.apply(throwable);
            }
        };
    }
}

