/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.AbortMultipartUploadEvent;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.CompleteMultipartUploadEvent;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ExtraUploadMetadata;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.UploadMetadata;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import lombok.NonNull;
import org.apache.hadoop.fs.Path;

public final class MultipartUploadEvents {
    public static CompleteMultipartUploadEvent createCompleteEvent(@NonNull Path path, @NonNull UploadMetadata uploadMetadata) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (uploadMetadata == null) {
            throw new NullPointerException("uploadMetadata is marked non-null but is null");
        }
        return MultipartUploadEvents.createCompleteEvent(S3UriUtils.pathToBucket(path), S3UriUtils.pathToKey(path), uploadMetadata);
    }

    public static CompleteMultipartUploadEvent createCompleteEvent(@NonNull String bucket, @NonNull String key, @NonNull UploadMetadata uploadMetadata) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (uploadMetadata == null) {
            throw new NullPointerException("uploadMetadata is marked non-null but is null");
        }
        return CompleteMultipartUploadEvent.builder().bucket(bucket).key(key).uploadId(uploadMetadata.getUploadId()).partETags(uploadMetadata.getPartETags()).totalLength(uploadMetadata.getTotalLength()).extraUploadMetadata(ExtraUploadMetadata.empty()).build();
    }

    public static AbortMultipartUploadEvent createAbortEvent(@NonNull Path path, @NonNull UploadMetadata uploadMetadata) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (uploadMetadata == null) {
            throw new NullPointerException("uploadMetadata is marked non-null but is null");
        }
        return MultipartUploadEvents.createAbortEvent(S3UriUtils.pathToBucket(path), S3UriUtils.pathToKey(path), uploadMetadata);
    }

    public static AbortMultipartUploadEvent createAbortEvent(@NonNull String bucket, @NonNull String key, @NonNull UploadMetadata uploadMetadata) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (uploadMetadata == null) {
            throw new NullPointerException("uploadMetadata is marked non-null but is null");
        }
        return AbortMultipartUploadEvent.builder().bucket(bucket).key(key).uploadId(uploadMetadata.getUploadId()).build();
    }

    private MultipartUploadEvents() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

