/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.staging.Task;
import com.amazon.ws.emr.hadoop.fs.staging.TaskCoordinator;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.staging.StagedFileMetadata;
import org.apache.hadoop.fs.staging.StagingDirectoryMetadata;

class ExternalStagingTaskCoordinator
implements TaskCoordinator {
    private final Iterator<StagingDirectoryMetadata> stagingDirectories;
    private final TaskFactory mainFactory;
    private final TaskFactory onFailureFactory;
    private volatile TaskFactory currentTaskFactory;
    private StagingDirectoryMetadata currentDir;
    private boolean needToSubmitDirTaskForCurrentDir = false;
    private final AtomicReference<Task> lastUnfinishedBlockingTask = new AtomicReference<Object>(null);

    ExternalStagingTaskCoordinator(@NonNull Iterator<StagingDirectoryMetadata> stagingDirectories, @NonNull TaskFactory mainFactory, @NonNull TaskFactory onFailureFactory) {
        if (stagingDirectories == null) {
            throw new NullPointerException("stagingDirectories is marked non-null but is null");
        }
        if (mainFactory == null) {
            throw new NullPointerException("mainFactory is marked non-null but is null");
        }
        if (onFailureFactory == null) {
            throw new NullPointerException("onFailureFactory is marked non-null but is null");
        }
        this.stagingDirectories = stagingDirectories;
        this.mainFactory = this.addTaskCallBack(mainFactory);
        this.onFailureFactory = this.addTaskCallBack(onFailureFactory);
        this.currentTaskFactory = this.mainFactory;
    }

    private TaskFactory addTaskCallBack(final TaskFactory delegatedFactory) {
        return new TaskFactory(){

            @Override
            public Task newFileTask(StagedFileMetadata stagedFileMetadata) {
                Task delegatedTask = delegatedFactory.newFileTask(stagedFileMetadata);
                return ExternalStagingTaskCoordinator.this.addTaskCallBack(delegatedTask);
            }

            @Override
            public Task newDirectoryTask(Path destinationPath) {
                Task delegatedTask = delegatedFactory.newDirectoryTask(destinationPath);
                return ExternalStagingTaskCoordinator.this.addTaskCallBack(delegatedTask);
            }
        };
    }

    private Task addTaskCallBack(Task delegated) {
        return new TaskWithCallback(delegated, this::onTaskSuccess, this::onTaskFailure);
    }

    @Override
    public boolean hasRemainingTasks() {
        return this.currentDirHasTasks() || this.loadNextDir();
    }

    private boolean currentDirHasTasks() {
        return this.currentDir != null && (this.needToSubmitDirTaskForCurrentDir || this.currentDir.getStagedFiles().hasNext());
    }

    private boolean loadNextDir() {
        while (this.stagingDirectories.hasNext()) {
            this.currentDir = this.stagingDirectories.next();
            if (this.currentDir == null) continue;
            this.needToSubmitDirTaskForCurrentDir = true;
            return true;
        }
        return false;
    }

    @Override
    public Task nextTask() {
        Task result;
        if (!this.hasRemainingTasks()) {
            throw new NoSuchElementException();
        }
        if (this.isBlockingNextTaskCall()) {
            throw new IllegalStateException("nextTask() can only be called after previous blocking task is finished");
        }
        if (this.needToSubmitDirTaskForCurrentDir) {
            result = this.currentTaskFactory.newDirectoryTask(this.currentDir.getDestinationPath());
            this.needToSubmitDirTaskForCurrentDir = false;
        } else {
            result = this.currentTaskFactory.newFileTask((StagedFileMetadata)this.currentDir.getStagedFiles().next());
        }
        this.updateLastTask(result);
        return result;
    }

    private boolean isBlockingNextTaskCall() {
        return this.lastUnfinishedBlockingTask.get() != null;
    }

    private void updateLastTask(Task task) {
        if (task.isBlockingTask()) {
            this.lastUnfinishedBlockingTask.set(task);
        }
    }

    @VisibleForTesting
    void onTaskFailure(Task task) {
        this.updateLastTaskStatusToFinished(task);
        this.currentTaskFactory = this.onFailureFactory;
    }

    @VisibleForTesting
    void onTaskSuccess(Task task) {
        this.updateLastTaskStatusToFinished(task);
    }

    private void updateLastTaskStatusToFinished(Task task) {
        this.lastUnfinishedBlockingTask.compareAndSet(task, null);
    }

    static interface TaskFactory {
        public Task newFileTask(StagedFileMetadata var1);

        public Task newDirectoryTask(Path var1);
    }

    class TaskWithCallback
    implements Task {
        private final Task delegated;
        private final Consumer<Task> onTaskSuccess;
        private final Consumer<Task> onTaskFailure;

        @Override
        public boolean isBlockingTask() {
            return this.delegated.isBlockingTask();
        }

        @Override
        public void run() throws IOException {
            try {
                this.delegated.run();
                ExternalStagingTaskCoordinator.this.onTaskSuccess(this);
            }
            catch (Throwable cause) {
                try {
                    ExternalStagingTaskCoordinator.this.onTaskFailure(this);
                }
                catch (Throwable t) {
                    cause.addSuppressed(t);
                }
                throw cause;
            }
        }

        @Override
        public boolean abandonRemainingTasks(Throwable throwable) {
            return this.delegated.abandonRemainingTasks(throwable);
        }

        public TaskWithCallback(Task delegated, Consumer<Task> onTaskSuccess, Consumer<Task> onTaskFailure) {
            this.delegated = delegated;
            this.onTaskSuccess = onTaskSuccess;
            this.onTaskFailure = onTaskFailure;
        }
    }
}

