/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.MultipartUploadDispatcher;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonServiceException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.io.input.ClassLoaderObjectInputStream;
import com.amazon.ws.emr.hadoop.fs.staging.ExternalStagingTaskCoordinator;
import com.amazon.ws.emr.hadoop.fs.staging.MultipartUploadEvents;
import com.amazon.ws.emr.hadoop.fs.staging.StagedFilesExecutor;
import com.amazon.ws.emr.hadoop.fs.staging.Task;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.UploadMetadata;
import com.amazon.ws.emr.hadoop.fs.staging.path.PathOverlapChecker;
import com.amazon.ws.emr.hadoop.fs.util.AmazonServiceExceptions;
import com.amazon.ws.emr.hadoop.fs.util.ExceptionCollector;
import com.amazon.ws.emr.hadoop.fs.util.HadoopPaths;
import com.amazon.ws.emr.hadoop.fs.util.MoreIterators;
import com.amazon.ws.emr.hadoop.fs.util.io.IOConsumer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.staging.PublishMode;
import org.apache.hadoop.fs.staging.StagedFileMetadata;
import org.apache.hadoop.fs.staging.StagingDirectoryMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalStagedFileCommitter {
    private static final Logger logger = LoggerFactory.getLogger(ExternalStagedFileCommitter.class);
    @NonNull
    private final MultipartUploadDispatcher uploadDispatcher;
    @NonNull
    private final Consumer<Path> pathChecker;
    @NonNull
    private final IOConsumer<Path> pathDeleter;
    @NonNull
    private final ListeningExecutorService exec;
    private final int maxActiveTasks;

    void publishOrDelete(@NonNull Iterator<StagingDirectoryMetadata> dirIterator, @NonNull PublishMode publishMode) throws IOException {
        if (dirIterator == null) {
            throw new NullPointerException("dirIterator is marked non-null but is null");
        }
        if (publishMode == null) {
            throw new NullPointerException("publishMode is marked non-null but is null");
        }
        ExceptionCollector exceptionCollector = ExceptionCollector.withDefaultMaxCollectedExceptions();
        if (this.maxActiveTasks <= 1) {
            this.sequentialPublishOrDelete(dirIterator, publishMode, exceptionCollector);
        } else {
            this.parallelPublishOrDelete(dirIterator, publishMode, exceptionCollector);
        }
        exceptionCollector.rethrowIfFirstIs(IllegalArgumentException.class).throwIfNotEmpty(() -> new IOException("Failed publishing one or more staging directories"));
    }

    void delete(@NonNull Iterator<StagingDirectoryMetadata> dirIterator) throws IOException {
        if (dirIterator == null) {
            throw new NullPointerException("dirIterator is marked non-null but is null");
        }
        ExceptionCollector exceptionCollector = ExceptionCollector.withDefaultMaxCollectedExceptions();
        if (this.maxActiveTasks <= 1) {
            this.sequentialDelete(dirIterator, exceptionCollector);
        } else {
            this.parallelDelete(dirIterator, exceptionCollector);
        }
        exceptionCollector.rethrowIfFirstIs(IllegalArgumentException.class).throwIfNotEmpty(() -> new IOException("Failed deleting one or more staging directories"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sequentialPublishOrDelete(Iterator<StagingDirectoryMetadata> dirIterator, PublishMode publishMode, ExceptionCollector exceptionCollector) {
        StagingDirectoryMetadata currentDir = null;
        try {
            PathOverlapChecker dirOverlapCheck = new PathOverlapChecker();
            while (dirIterator.hasNext() && exceptionCollector.isEmpty()) {
                currentDir = dirIterator.next();
                if (currentDir == null) continue;
                if (publishMode == PublishMode.OVERWRITE) {
                    this.deleteDir(currentDir.getDestinationPath(), dirOverlapCheck);
                }
                while (currentDir.getStagedFiles().hasNext() && exceptionCollector.isEmpty()) {
                    StagedFileMetadata stagedFileMetadata = (StagedFileMetadata)currentDir.getStagedFiles().next();
                    this.publishOrDeleteOneFile(stagedFileMetadata, exceptionCollector);
                }
            }
        }
        catch (IOException | RuntimeException exception) {
            exceptionCollector.add(exception);
        }
        finally {
            if (!exceptionCollector.isEmpty()) {
                logger.warn("Deleting any remaining staged files because publishing failed");
            }
            Iterator<StagingDirectoryMetadata> deleteDirIterator = MoreIterators.prepend(currentDir, dirIterator);
            this.sequentialDelete(deleteDirIterator, exceptionCollector);
        }
    }

    private void sequentialDelete(Iterator<StagingDirectoryMetadata> iterator, ExceptionCollector exceptionCollector) {
        int maxLogErrorFailDeletions = 5;
        int failedDeletions = 0;
        try {
            while (iterator.hasNext()) {
                StagingDirectoryMetadata currentDir = iterator.next();
                if (currentDir == null) continue;
                Iterator stagedFileMetadataIterator = currentDir.getStagedFiles();
                while (stagedFileMetadataIterator.hasNext()) {
                    boolean logErrorFailedDeletion;
                    StagedFileMetadata stagedFileMetadata = (StagedFileMetadata)stagedFileMetadataIterator.next();
                    if (this.deleteOneFile(stagedFileMetadata, exceptionCollector, logErrorFailedDeletion = failedDeletions < 5)) continue;
                    ++failedDeletions;
                }
            }
        }
        catch (IOException | RuntimeException exception) {
            exceptionCollector.add(exception);
        }
    }

    private void publishOrDeleteOneFile(@Nullable StagedFileMetadata stagedFileMetadata, ExceptionCollector exceptionCollector) {
        try {
            this.publishOrDeleteOneFile(stagedFileMetadata);
        }
        catch (IOException | RuntimeException exception) {
            exceptionCollector.add(exception);
        }
    }

    private void publishOrDeleteOneFile(@Nullable StagedFileMetadata stagedFileMetadata) throws IOException {
        UploadMetadata uploadMetadata;
        Path destinationPath;
        if (stagedFileMetadata == null) {
            return;
        }
        try {
            destinationPath = stagedFileMetadata.getDestinationPath();
            this.checkPath(destinationPath);
            uploadMetadata = this.castToUploadMetadataOrThrow(stagedFileMetadata.getStagingMetadata());
        }
        catch (IOException | RuntimeException exception) {
            this.logPublishingStagedFileFailed(stagedFileMetadata, exception);
            throw exception;
        }
        try {
            this.completeOneFile(destinationPath, uploadMetadata);
        }
        catch (IOException | RuntimeException exception) {
            if (this.isUploadNotFound(exception)) {
                this.logPublishingStagedFileFailed(stagedFileMetadata, exception);
                throw exception;
            }
            ExceptionCollector exceptionCollector = new ExceptionCollector();
            exceptionCollector.add(exception);
            this.logPublishingStagedFileFailedAndWillBeDeleted(stagedFileMetadata, exception);
            this.abortOneFile(destinationPath, uploadMetadata, exceptionCollector);
            exceptionCollector.rethrowIfNotEmpty(IOException.class);
        }
    }

    private boolean deleteOneFile(@Nullable StagedFileMetadata stagedFileMetadata, ExceptionCollector exceptionCollector, boolean logErrorFailedDeletion) throws IOException {
        try {
            this.deleteOneFile(stagedFileMetadata);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            boolean abortDeletion = AmazonServiceExceptions.isAccessDeniedByAmazonService(exception);
            if (abortDeletion) {
                this.logAbortDeletingStagedFiles(stagedFileMetadata, exception);
                throw exception;
            }
            if (logErrorFailedDeletion) {
                logger.error("Failed deleting staged file '{}'", (Object)stagedFileMetadata, (Object)exception);
            } else {
                logger.debug("Failed deleting staged file '{}'", (Object)stagedFileMetadata, (Object)exception);
            }
            exceptionCollector.add(exception);
            return false;
        }
    }

    private void deleteOneFile(@Nullable StagedFileMetadata stagedFileMetadata) throws IOException {
        if (stagedFileMetadata == null) {
            return;
        }
        Path destinationPath = stagedFileMetadata.getDestinationPath();
        this.checkPath(destinationPath);
        UploadMetadata uploadMetadata = this.castToUploadMetadataOrThrow(stagedFileMetadata.getStagingMetadata());
        this.abortOneFile(destinationPath, uploadMetadata);
    }

    private void parallelPublishOrDelete(Iterator<StagingDirectoryMetadata> stagingDirsIterator, PublishMode publishMode, ExceptionCollector exceptionCollector) {
        ExternalStagingTaskCoordinator taskCoordinator = new ExternalStagingTaskCoordinator(stagingDirsIterator, this.publishDirTaskFactory(publishMode), this.deleteDirTaskFactory());
        this.parallelExecute(taskCoordinator, exceptionCollector);
    }

    private void parallelDelete(Iterator<StagingDirectoryMetadata> stagingDirsIterator, ExceptionCollector exceptionCollector) {
        ExternalStagingTaskCoordinator taskCoordinator = new ExternalStagingTaskCoordinator(stagingDirsIterator, this.deleteDirTaskFactory(), this.deleteDirTaskFactory());
        this.parallelExecute(taskCoordinator, exceptionCollector);
    }

    private void parallelExecute(ExternalStagingTaskCoordinator taskCoordinator, ExceptionCollector exceptionCollector) {
        try {
            StagedFilesExecutor stagedFilesExecutor = this.createStagedFilesExecutor();
            stagedFilesExecutor.run(taskCoordinator);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            exceptionCollector.add(ie);
        }
        catch (IOException | RuntimeException exception) {
            exceptionCollector.add(exception);
        }
    }

    private ExternalStagingTaskCoordinator.TaskFactory publishDirTaskFactory(final PublishMode publishMode) {
        return new ExternalStagingTaskCoordinator.TaskFactory(){
            PathOverlapChecker dirOverlapCheck = new PathOverlapChecker();

            @Override
            public Task newFileTask(@Nullable StagedFileMetadata stagedFileMetadata) {
                return Task.newNonBlockingTask(() -> ExternalStagedFileCommitter.this.publishOrDeleteOneFile(stagedFileMetadata));
            }

            @Override
            public Task newDirectoryTask(Path destinationPath) {
                if (publishMode == PublishMode.INSERT) {
                    return Task.newNonBlockingTask(() -> {});
                }
                return Task.newBlockingTask(() -> ExternalStagedFileCommitter.this.deleteDir(destinationPath, this.dirOverlapCheck));
            }
        };
    }

    private ExternalStagingTaskCoordinator.TaskFactory deleteDirTaskFactory() {
        return new ExternalStagingTaskCoordinator.TaskFactory(){

            @Override
            public Task newFileTask(StagedFileMetadata stagedFileMetadata) {
                return Task.newNonBlockingTask(() -> ExternalStagedFileCommitter.this.deleteOneFile(stagedFileMetadata), throwable -> {
                    boolean result = AmazonServiceExceptions.isAccessDeniedByAmazonService(throwable);
                    if (result) {
                        ExternalStagedFileCommitter.this.logAbortDeletingStagedFiles(stagedFileMetadata, throwable);
                    }
                    return result;
                });
            }

            @Override
            public Task newDirectoryTask(Path destinationPath) {
                return Task.newNonBlockingTask(() -> {});
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UploadMetadata castToUploadMetadataOrThrow(Serializable objectNeedsToCast) throws IllegalArgumentException, IOException {
        ClassLoader classLoader = UploadMetadata.class.getClassLoader();
        try (ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(classLoader, new ByteArrayInputStream((byte[])objectNeedsToCast));){
            UploadMetadata uploadMetadata = (UploadMetadata)ois.readObject();
            return uploadMetadata;
        }
        catch (IOException ioe) {
            throw new IOException(String.format("Failed to deserialize or load external staged file's staging metadata %s.", objectNeedsToCast), ioe);
        }
        catch (ClassNotFoundException | RuntimeException e) {
            throw new IllegalArgumentException(String.format("External staged file's staging metadata %s is not supported by EmrFS.", objectNeedsToCast), e);
        }
    }

    private void checkPath(Path path) {
        HadoopPaths.checkNotOpaque(path);
        Preconditions.checkArgument(HadoopPaths.isFullyQualified(path), "External staged file or staging dir path (%s) must be fully qualified", path);
        this.pathChecker.accept(path);
    }

    private void deleteDir(Path dirPath, PathOverlapChecker overlapCheck) throws IOException {
        this.checkPath(dirPath);
        overlapCheck.checkAndAddPath(dirPath);
        this.pathDeleter.accept(dirPath);
    }

    private boolean isUploadNotFound(Exception exception) {
        return exception instanceof AmazonServiceException && ((AmazonServiceException)exception).getStatusCode() == 404;
    }

    private void abortOneFile(Path path, UploadMetadata uploadMetadata, ExceptionCollector exceptionCollector) {
        try {
            this.abortOneFile(path, uploadMetadata);
        }
        catch (IOException | RuntimeException exception) {
            exceptionCollector.add(exception);
        }
    }

    private void abortOneFile(Path path, UploadMetadata uploadMetadata) throws IOException {
        this.uploadDispatcher.abort(MultipartUploadEvents.createAbortEvent(path, uploadMetadata));
    }

    private void completeOneFile(Path path, UploadMetadata uploadMetadata) throws IOException {
        this.uploadDispatcher.complete(MultipartUploadEvents.createCompleteEvent(path, uploadMetadata));
    }

    private void logPublishingStagedFileFailed(StagedFileMetadata stagedFileMetadata, Exception exception) {
        logger.error("Failed publishing staged file '{}'.", (Object)stagedFileMetadata, (Object)exception);
    }

    private void logPublishingStagedFileFailedAndWillBeDeleted(StagedFileMetadata stagedFileMetadata, Exception exception) {
        logger.error("Failed publishing staged file '{}'. Deleting the file because of the failure.", (Object)stagedFileMetadata, (Object)exception);
    }

    private void logAbortDeletingStagedFiles(StagedFileMetadata causeStagedFileMetadata, Throwable throwable) {
        logger.error("Failed deleting staged file '{}'. Aborting deletion of remaining staged file if any. See https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-upload-s3.html#emr-bucket-bestpractices for how to clean up failed multipart uploads", (Object)causeStagedFileMetadata, (Object)throwable);
    }

    private StagedFilesExecutor createStagedFilesExecutor() {
        return new StagedFilesExecutor(this.exec, this.maxActiveTasks);
    }

    ExternalStagedFileCommitter(@NonNull MultipartUploadDispatcher uploadDispatcher, @NonNull Consumer<Path> pathChecker, @NonNull IOConsumer<Path> pathDeleter, @NonNull ListeningExecutorService exec, int maxActiveTasks) {
        if (uploadDispatcher == null) {
            throw new NullPointerException("uploadDispatcher is marked non-null but is null");
        }
        if (pathChecker == null) {
            throw new NullPointerException("pathChecker is marked non-null but is null");
        }
        if (pathDeleter == null) {
            throw new NullPointerException("pathDeleter is marked non-null but is null");
        }
        if (exec == null) {
            throw new NullPointerException("exec is marked non-null but is null");
        }
        this.uploadDispatcher = uploadDispatcher;
        this.pathChecker = pathChecker;
        this.pathDeleter = pathDeleter;
        this.exec = exec;
        this.maxActiveTasks = maxActiveTasks;
    }

    public static ExternalStagedFileCommitterBuilder builder() {
        return new ExternalStagedFileCommitterBuilder();
    }

    public static class ExternalStagedFileCommitterBuilder {
        private MultipartUploadDispatcher uploadDispatcher;
        private Consumer<Path> pathChecker;
        private IOConsumer<Path> pathDeleter;
        private ListeningExecutorService exec;
        private int maxActiveTasks;

        ExternalStagedFileCommitterBuilder() {
        }

        public ExternalStagedFileCommitterBuilder uploadDispatcher(@NonNull MultipartUploadDispatcher uploadDispatcher) {
            if (uploadDispatcher == null) {
                throw new NullPointerException("uploadDispatcher is marked non-null but is null");
            }
            this.uploadDispatcher = uploadDispatcher;
            return this;
        }

        public ExternalStagedFileCommitterBuilder pathChecker(@NonNull Consumer<Path> pathChecker) {
            if (pathChecker == null) {
                throw new NullPointerException("pathChecker is marked non-null but is null");
            }
            this.pathChecker = pathChecker;
            return this;
        }

        public ExternalStagedFileCommitterBuilder pathDeleter(@NonNull IOConsumer<Path> pathDeleter) {
            if (pathDeleter == null) {
                throw new NullPointerException("pathDeleter is marked non-null but is null");
            }
            this.pathDeleter = pathDeleter;
            return this;
        }

        public ExternalStagedFileCommitterBuilder exec(@NonNull ListeningExecutorService exec) {
            if (exec == null) {
                throw new NullPointerException("exec is marked non-null but is null");
            }
            this.exec = exec;
            return this;
        }

        public ExternalStagedFileCommitterBuilder maxActiveTasks(int maxActiveTasks) {
            this.maxActiveTasks = maxActiveTasks;
            return this;
        }

        public ExternalStagedFileCommitter build() {
            return new ExternalStagedFileCommitter(this.uploadDispatcher, this.pathChecker, this.pathDeleter, this.exec, this.maxActiveTasks);
        }

        public String toString() {
            return "ExternalStagedFileCommitter.ExternalStagedFileCommitterBuilder(uploadDispatcher=" + this.uploadDispatcher + ", pathChecker=" + this.pathChecker + ", pathDeleter=" + this.pathDeleter + ", exec=" + this.exec + ", maxActiveTasks=" + this.maxActiveTasks + ")";
        }
    }
}

