/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import com.amazon.ws.emr.hadoop.fs.staging.DeferredUpload;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingRoot;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferredUploadStatistics {
    private static final Logger logger = LoggerFactory.getLogger(DeferredUploadStatistics.class);
    private static final double MEDIAN_PERCENTILE = 50.0;
    private final DescriptiveStatistics deferredTimeStats = new DescriptiveStatistics();
    private final DescriptiveStatistics fileSizeStats = new DescriptiveStatistics();
    @NonNull
    private final StagingRoot root;

    private static String statsToString(DescriptiveStatistics stats, String desc, String units) {
        return String.format("%s (%s): min=%s, avg=%s, median=%s, max=%s", desc, units, Math.round(stats.getMin()), Math.round(stats.getMean()), Math.round(stats.getPercentile(50.0)), Math.round(stats.getMax()));
    }

    public void addCompletedUpload(@NonNull DeferredUpload upload) {
        if (upload == null) {
            throw new NullPointerException("upload is marked non-null but is null");
        }
        Preconditions.checkArgument(upload.isCompleted(), "upload must be completed");
        this.deferredTimeStats.addValue(upload.getCompletedTime() - upload.getDeferralTime());
        this.fileSizeStats.addValue(upload.getMetadata().getTotalLength());
    }

    public void log() {
        long numFiles = this.deferredTimeStats.getN();
        logger.info("Completed {} deferred upload(s) under staging directory at '{}' ({}; {})", new Object[]{numFiles, this.root, DeferredUploadStatistics.statsToString(this.deferredTimeStats, "upload completion deferral time", "msec"), DeferredUploadStatistics.statsToString(this.fileSizeStats, "file size", "bytes")});
    }

    public DeferredUploadStatistics(@NonNull StagingRoot root) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        this.root = root;
    }
}

