/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging;

import com.amazon.ws.emr.hadoop.fs.s3n.FileStatusFactory;
import com.amazon.ws.emr.hadoop.fs.staging.ExternalStagedFileCommitter;
import com.amazon.ws.emr.hadoop.fs.staging.StagingMechanism;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagingMetadataStore;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagingStatus;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPath;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPathConverter;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingRoot;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.staging.PublishMode;
import org.apache.hadoop.fs.staging.StagedFileMetadata;
import org.apache.hadoop.fs.staging.StagingDirectoryMetadata;
import org.apache.hadoop.fs.staging.UnsupportedStagingDirectoryOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultStagingMechanism
implements StagingMechanism {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStagingMechanism.class);
    @NonNull
    private final StagingPathConverter pathConverter;
    @NonNull
    private final StagingMetadataStore store;
    @NonNull
    private final UnaryOperator<Path> pathQualifier;
    @NonNull
    private final FileStatusFactory fileStatusFactory;
    @NonNull
    private final ExternalStagedFileCommitter externalStagedFileCommitter;
    private final boolean supportsExporting;

    public boolean isStagingDirectoryPath(@Nonnull Path path) {
        Path qualifiedPath = (Path)this.pathQualifier.apply(path);
        return this.pathConverter.isStagingPath(qualifiedPath);
    }

    public boolean hasStagingDirectory(@Nonnull Path destinationPath, @Nonnull String stageName) throws IOException {
        return this.store.hasStagingDirectory(this.getStagingRoot(destinationPath, stageName));
    }

    public Path makeStagingDirectory(@Nonnull Path destinationPath, @Nonnull String stageName) throws IOException {
        Path qualifiedDestinationPath = (Path)this.pathQualifier.apply(destinationPath);
        if (this.pathConverter.isStagingPath(qualifiedDestinationPath)) {
            throw new UnsupportedStagingDirectoryOperationException(String.format("Cannot create a staging directory under a staging directory (destinationPath: %s, stageName: %s)", qualifiedDestinationPath, stageName));
        }
        StagingRoot stagingRoot = StagingRoot.of(qualifiedDestinationPath, stageName);
        this.store.makeStagingDirectory(stagingRoot);
        return this.pathConverter.toHadoopPath(stagingRoot);
    }

    public void publishStagingDirectory(@Nonnull Path outputPath, @Nonnull String stageName) throws IOException {
        this.store.publishStagingDirectory(this.getStagingRoot(outputPath, stageName));
    }

    public void deleteStagingDirectory(@Nonnull Path destinationPath, @Nonnull String stageName) throws IOException {
        this.store.deleteStagingDirectory(this.getStagingRoot(destinationPath, stageName));
    }

    public boolean supportsExporting() {
        return this.supportsExporting;
    }

    public Iterator<StagedFileMetadata> exportStagingDirectory(@NonNull Path destinationPath, @NonNull String stageName) throws IOException {
        if (destinationPath == null) {
            throw new NullPointerException("destinationPath is marked non-null but is null");
        }
        if (stageName == null) {
            throw new NullPointerException("stageName is marked non-null but is null");
        }
        this.checkSupportExporting("exportStagingDirectory");
        StagingRoot stagingRoot = this.getStagingRoot(destinationPath, stageName);
        return this.store.exportStagingDirectory(stagingRoot);
    }

    public void publishOrDeleteExternalStagingDirectories(@NonNull Iterator<StagingDirectoryMetadata> stagingDirectoryMetadataIterator, @NonNull PublishMode publishMode) throws IOException {
        if (stagingDirectoryMetadataIterator == null) {
            throw new NullPointerException("stagingDirectoryMetadataIterator is marked non-null but is null");
        }
        if (publishMode == null) {
            throw new NullPointerException("publishMode is marked non-null but is null");
        }
        this.checkSupportExporting("publishOrDeleteExternalStagingDirectories");
        this.externalStagedFileCommitter.publishOrDelete(stagingDirectoryMetadataIterator, publishMode);
    }

    public void deleteExternalStagingDirectories(@NonNull Iterator<StagingDirectoryMetadata> stagingDirectoryMetadataIterator) throws IOException {
        if (stagingDirectoryMetadataIterator == null) {
            throw new NullPointerException("stagingDirectoryMetadataIterator is marked non-null but is null");
        }
        this.checkSupportExporting("deleteExternalStagingDirectories");
        this.externalStagedFileCommitter.delete(stagingDirectoryMetadataIterator);
    }

    private void checkSupportExporting(String methodName) throws UnsupportedStagingDirectoryOperationException {
        if (!this.supportsExporting()) {
            throw new UnsupportedStagingDirectoryOperationException(String.format("Cannot #%s because this staging directory service instance does not support exporting. Please check #supportsExporting() before exporting staging directory, publishing external staged files, or deleting external staged files", methodName));
        }
    }

    @Override
    public FileStatus getFileStatus(@Nonnull Path path) throws IOException {
        Path qualifiedDestinationPath = (Path)this.pathQualifier.apply(path);
        StagingPath stagingPath = this.pathConverter.toStagingPath(qualifiedDestinationPath);
        return this.toFileStatus(this.store.getStatus(stagingPath));
    }

    private StagingRoot getStagingRoot(Path destinationPath, String stageName) {
        Path qualifiedDestinationPath = (Path)this.pathQualifier.apply(destinationPath);
        return StagingRoot.of(qualifiedDestinationPath, stageName);
    }

    private FileStatus toFileStatus(StagingStatus status) {
        Path path = this.pathConverter.toHadoopPath(status.getPath());
        if (status.isDirectory()) {
            return this.fileStatusFactory.newDirectory(path);
        }
        return this.fileStatusFactory.newFile(path, status.getLength(), status.getModificationTime());
    }

    @Override
    public void close() throws IOException {
        this.store.close();
    }

    DefaultStagingMechanism(@NonNull StagingPathConverter pathConverter, @NonNull StagingMetadataStore store, @NonNull UnaryOperator<Path> pathQualifier, @NonNull FileStatusFactory fileStatusFactory, @NonNull ExternalStagedFileCommitter externalStagedFileCommitter, boolean supportsExporting) {
        if (pathConverter == null) {
            throw new NullPointerException("pathConverter is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        if (pathQualifier == null) {
            throw new NullPointerException("pathQualifier is marked non-null but is null");
        }
        if (fileStatusFactory == null) {
            throw new NullPointerException("fileStatusFactory is marked non-null but is null");
        }
        if (externalStagedFileCommitter == null) {
            throw new NullPointerException("externalStagedFileCommitter is marked non-null but is null");
        }
        this.pathConverter = pathConverter;
        this.store = store;
        this.pathQualifier = pathQualifier;
        this.fileStatusFactory = fileStatusFactory;
        this.externalStagedFileCommitter = externalStagedFileCommitter;
        this.supportsExporting = supportsExporting;
    }

    public static DefaultStagingMechanismBuilder builder() {
        return new DefaultStagingMechanismBuilder();
    }

    public static class DefaultStagingMechanismBuilder {
        private StagingPathConverter pathConverter;
        private StagingMetadataStore store;
        private UnaryOperator<Path> pathQualifier;
        private FileStatusFactory fileStatusFactory;
        private ExternalStagedFileCommitter externalStagedFileCommitter;
        private boolean supportsExporting;

        DefaultStagingMechanismBuilder() {
        }

        public DefaultStagingMechanismBuilder pathConverter(@NonNull StagingPathConverter pathConverter) {
            if (pathConverter == null) {
                throw new NullPointerException("pathConverter is marked non-null but is null");
            }
            this.pathConverter = pathConverter;
            return this;
        }

        public DefaultStagingMechanismBuilder store(@NonNull StagingMetadataStore store) {
            if (store == null) {
                throw new NullPointerException("store is marked non-null but is null");
            }
            this.store = store;
            return this;
        }

        public DefaultStagingMechanismBuilder pathQualifier(@NonNull UnaryOperator<Path> pathQualifier) {
            if (pathQualifier == null) {
                throw new NullPointerException("pathQualifier is marked non-null but is null");
            }
            this.pathQualifier = pathQualifier;
            return this;
        }

        public DefaultStagingMechanismBuilder fileStatusFactory(@NonNull FileStatusFactory fileStatusFactory) {
            if (fileStatusFactory == null) {
                throw new NullPointerException("fileStatusFactory is marked non-null but is null");
            }
            this.fileStatusFactory = fileStatusFactory;
            return this;
        }

        public DefaultStagingMechanismBuilder externalStagedFileCommitter(@NonNull ExternalStagedFileCommitter externalStagedFileCommitter) {
            if (externalStagedFileCommitter == null) {
                throw new NullPointerException("externalStagedFileCommitter is marked non-null but is null");
            }
            this.externalStagedFileCommitter = externalStagedFileCommitter;
            return this;
        }

        public DefaultStagingMechanismBuilder supportsExporting(boolean supportsExporting) {
            this.supportsExporting = supportsExporting;
            return this;
        }

        public DefaultStagingMechanism build() {
            return new DefaultStagingMechanism(this.pathConverter, this.store, this.pathQualifier, this.fileStatusFactory, this.externalStagedFileCommitter, this.supportsExporting);
        }

        public String toString() {
            return "DefaultStagingMechanism.DefaultStagingMechanismBuilder(pathConverter=" + this.pathConverter + ", store=" + this.store + ", pathQualifier=" + this.pathQualifier + ", fileStatusFactory=" + this.fileStatusFactory + ", externalStagedFileCommitter=" + this.externalStagedFileCommitter + ", supportsExporting=" + this.supportsExporting + ")";
        }
    }
}

