/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.stat.descriptive.summary;

import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.stat.descriptive.WeightedEvaluation;
import java.io.Serializable;

public class Product
extends AbstractStorelessUnivariateStatistic
implements Serializable,
WeightedEvaluation {
    private static final long serialVersionUID = 2824226005990582538L;
    private long n;
    private double value;

    public Product() {
        this.n = 0L;
        this.value = Double.NaN;
    }

    public Product(Product original) {
        Product.copy(original, this);
    }

    public void increment(double d) {
        this.value = this.n == 0L ? d : (this.value *= d);
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    public double evaluate(double[] values, int begin, int length) {
        double product = Double.NaN;
        if (this.test(values, begin, length)) {
            product = 1.0;
            for (int i = begin; i < begin + length; ++i) {
                product *= values[i];
            }
        }
        return product;
    }

    public double evaluate(double[] values, double[] weights, int begin, int length) {
        double product = Double.NaN;
        if (this.test(values, weights, begin, length)) {
            product = 1.0;
            for (int i = begin; i < begin + length; ++i) {
                product *= Math.pow(values[i], weights[i]);
            }
        }
        return product;
    }

    public double evaluate(double[] values, double[] weights) {
        return this.evaluate(values, weights, 0, values.length);
    }

    public Product copy() {
        Product result = new Product();
        Product.copy(this, result);
        return result;
    }

    public static void copy(Product source, Product dest) {
        dest.n = source.n;
        dest.value = source.value;
    }
}

