/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.analysis.integration;

import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.FunctionEvaluationException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.MathRuntimeException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.MaxIterationsExceededException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.analysis.UnivariateRealFunction;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.analysis.integration.TrapezoidIntegrator;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.analysis.integration.UnivariateRealIntegratorImpl;

public class SimpsonIntegrator
extends UnivariateRealIntegratorImpl {
    @Deprecated
    public SimpsonIntegrator(UnivariateRealFunction f) {
        super(f, 64);
    }

    public SimpsonIntegrator() {
        super(64);
    }

    @Deprecated
    public double integrate(double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        return this.integrate(this.f, min, max);
    }

    public double integrate(UnivariateRealFunction f, double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        this.clearResult();
        this.verifyInterval(min, max);
        this.verifyIterationCount();
        TrapezoidIntegrator qtrap = new TrapezoidIntegrator();
        if (this.minimalIterationCount == 1) {
            double s = (4.0 * qtrap.stage(f, min, max, 1) - qtrap.stage(f, min, max, 0)) / 3.0;
            this.setResult(s, 1);
            return this.result;
        }
        double olds = 0.0;
        double oldt = qtrap.stage(f, min, max, 0);
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            double rLimit;
            double delta;
            double t = qtrap.stage(f, min, max, i);
            double s = (4.0 * t - oldt) / 3.0;
            if (i >= this.minimalIterationCount && ((delta = Math.abs(s - olds)) <= (rLimit = this.relativeAccuracy * (Math.abs(olds) + Math.abs(s)) * 0.5) || delta <= this.absoluteAccuracy)) {
                this.setResult(s, i);
                return this.result;
            }
            olds = s;
            oldt = t;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 64) {
            throw MathRuntimeException.createIllegalArgumentException("invalid iteration limits: min={0}, max={1}", 0, 64);
        }
    }
}

