/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec;

import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.CommandLine;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.ExecuteException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.ExecuteResultHandler;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.ExecuteStreamHandler;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.ExecuteWatchdog;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.Executor;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.ProcessDestroyer;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.PumpStreamHandler;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.launcher.CommandLauncher;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.launcher.CommandLauncherFactory;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class DefaultExecutor
implements Executor {
    private ExecuteStreamHandler streamHandler = new PumpStreamHandler();
    private File workingDirectory;
    private ExecuteWatchdog watchdog;
    private int[] exitValues;
    private final CommandLauncher launcher = CommandLauncherFactory.createVMLauncher();
    private ProcessDestroyer processDestroyer;
    private Thread executorThread;
    private IOException exceptionCaught = null;

    public DefaultExecutor() {
        this.exitValues = new int[0];
        this.workingDirectory = new File(".");
    }

    public ExecuteStreamHandler getStreamHandler() {
        return this.streamHandler;
    }

    public void setStreamHandler(ExecuteStreamHandler streamHandler) {
        this.streamHandler = streamHandler;
    }

    public ExecuteWatchdog getWatchdog() {
        return this.watchdog;
    }

    public void setWatchdog(ExecuteWatchdog watchDog) {
        this.watchdog = watchDog;
    }

    public ProcessDestroyer getProcessDestroyer() {
        return this.processDestroyer;
    }

    public void setProcessDestroyer(ProcessDestroyer processDestroyer) {
        this.processDestroyer = processDestroyer;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File dir) {
        this.workingDirectory = dir;
    }

    public int execute(CommandLine command) throws ExecuteException, IOException {
        return this.execute(command, (Map)null);
    }

    public int execute(CommandLine command, Map environment) throws ExecuteException, IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new IOException(this.workingDirectory + " doesn't exist.");
        }
        return this.executeInternal(command, environment, this.workingDirectory, this.streamHandler);
    }

    public void execute(CommandLine command, ExecuteResultHandler handler) throws ExecuteException, IOException {
        this.execute(command, null, handler);
    }

    public void execute(final CommandLine command, final Map environment, final ExecuteResultHandler handler) throws ExecuteException, IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new IOException(this.workingDirectory + " doesn't exist.");
        }
        if (this.watchdog != null) {
            this.watchdog.setProcessNotStarted();
        }
        Runnable runnable = new Runnable(){

            public void run() {
                int exitValue = -559038737;
                try {
                    exitValue = DefaultExecutor.this.executeInternal(command, environment, DefaultExecutor.this.workingDirectory, DefaultExecutor.this.streamHandler);
                    handler.onProcessComplete(exitValue);
                }
                catch (ExecuteException e) {
                    handler.onProcessFailed(e);
                }
                catch (Exception e) {
                    handler.onProcessFailed(new ExecuteException("Execution failed", exitValue, e));
                }
            }
        };
        this.executorThread = this.createThread(runnable, "Exec Default Executor");
        this.getExecutorThread().start();
    }

    public void setExitValue(int value) {
        this.setExitValues(new int[]{value});
    }

    public void setExitValues(int[] values) {
        this.exitValues = values == null ? null : (int[])values.clone();
    }

    public boolean isFailure(int exitValue) {
        if (this.exitValues == null) {
            return false;
        }
        if (this.exitValues.length == 0) {
            return this.launcher.isFailure(exitValue);
        }
        for (int i = 0; i < this.exitValues.length; ++i) {
            if (this.exitValues[i] != exitValue) continue;
            return false;
        }
        return true;
    }

    protected Thread createThread(Runnable runnable, String name) {
        return new Thread(runnable, name);
    }

    protected Process launch(CommandLine command, Map env, File dir) throws IOException {
        if (this.launcher == null) {
            throw new IllegalStateException("CommandLauncher can not be null");
        }
        if (dir != null && !dir.exists()) {
            throw new IOException(dir + " doesn't exist.");
        }
        return this.launcher.exec(command, env, dir);
    }

    protected Thread getExecutorThread() {
        return this.executorThread;
    }

    private void closeProcessStreams(Process process) {
        try {
            process.getInputStream().close();
        }
        catch (IOException e) {
            this.setExceptionCaught(e);
        }
        try {
            process.getOutputStream().close();
        }
        catch (IOException e) {
            this.setExceptionCaught(e);
        }
        try {
            process.getErrorStream().close();
        }
        catch (IOException e) {
            this.setExceptionCaught(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeInternal(CommandLine command, Map environment, File dir, ExecuteStreamHandler streams) throws IOException {
        this.setExceptionCaught(null);
        Process process = this.launch(command, environment, dir);
        try {
            streams.setProcessInputStream(process.getOutputStream());
            streams.setProcessOutputStream(process.getInputStream());
            streams.setProcessErrorStream(process.getErrorStream());
        }
        catch (IOException e) {
            process.destroy();
            throw e;
        }
        streams.start();
        try {
            if (this.getProcessDestroyer() != null) {
                this.getProcessDestroyer().add(process);
            }
            if (this.watchdog != null) {
                this.watchdog.start(process);
            }
            int exitValue = -559038737;
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                process.destroy();
            }
            finally {
                Thread.interrupted();
            }
            if (this.watchdog != null) {
                this.watchdog.stop();
            }
            try {
                streams.stop();
            }
            catch (IOException e) {
                this.setExceptionCaught(e);
            }
            this.closeProcessStreams(process);
            if (this.getExceptionCaught() != null) {
                throw this.getExceptionCaught();
            }
            if (this.watchdog != null) {
                try {
                    this.watchdog.checkException();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            if (this.isFailure(exitValue)) {
                throw new ExecuteException("Process exited with an error: " + exitValue, exitValue);
            }
            int n = exitValue;
            return n;
        }
        finally {
            if (this.getProcessDestroyer() != null) {
                this.getProcessDestroyer().remove(process);
            }
        }
    }

    private void setExceptionCaught(IOException e) {
        if (this.exceptionCaught == null) {
            this.exceptionCaught = e;
        }
    }

    private IOException getExceptionCaught() {
        return this.exceptionCaught;
    }
}

