/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.internal;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.annotation.SdkInternalApi;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SdkInternalApi
public class S3AccessPointBuilder {
    private static final Pattern HOSTNAME_COMPLIANT_PATTERN = Pattern.compile("[A-Za-z0-9\\-]+");
    private static final int HOSTNAME_MAX_LENGTH = 63;
    private Boolean dualstackEnabled;
    private String accessPointName;
    private String region;
    private String accountId;
    private String protocol;
    private String domain;
    private Boolean fipsEnabled;

    public static S3AccessPointBuilder create() {
        return new S3AccessPointBuilder();
    }

    public void setDualstackEnabled(Boolean dualstackEnabled) {
        this.dualstackEnabled = dualstackEnabled;
    }

    public S3AccessPointBuilder withDualstackEnabled(Boolean dualstackEnabled) {
        this.setDualstackEnabled(dualstackEnabled);
        return this;
    }

    public void setFipsEnabled(Boolean fipsEnabled) {
        this.fipsEnabled = fipsEnabled;
    }

    public S3AccessPointBuilder withFipsEnabled(Boolean fipsEnabled) {
        this.fipsEnabled = fipsEnabled;
        return this;
    }

    public void setAccessPointName(String accessPointName) {
        this.accessPointName = accessPointName;
    }

    public S3AccessPointBuilder withAccessPointName(String accessPointName) {
        this.setAccessPointName(accessPointName);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public S3AccessPointBuilder withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public S3AccessPointBuilder withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public S3AccessPointBuilder withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public S3AccessPointBuilder withDomain(String domain) {
        this.setDomain(domain);
        return this;
    }

    public URI toURI() {
        S3AccessPointBuilder.validateHostnameCompliant(this.accountId, "accountId");
        S3AccessPointBuilder.validateHostnameCompliant(this.accessPointName, "accessPointName");
        String dualStackSegment = Boolean.TRUE.equals(this.dualstackEnabled) ? ".dualstack" : "";
        String fipsSegment = Boolean.TRUE.equals(this.fipsEnabled) ? "fips-" : "";
        String uriString = String.format("%s://%s-%s.s3-accesspoint%s.%s%s.%s", this.protocol, this.accessPointName, this.accountId, dualStackSegment, fipsSegment, this.region, this.domain);
        return URI.create(uriString);
    }

    private static void validateHostnameCompliant(String hostnameComponent, String paramName) {
        if (hostnameComponent.isEmpty()) {
            throw new IllegalArgumentException(String.format("An S3 Access Point ARN has been passed that is not valid: the required '%s' component is missing.", paramName));
        }
        if (hostnameComponent.length() > 63) {
            throw new IllegalArgumentException(String.format("An S3 Access Point ARN has been passed that is not valid: the '%s' component exceeds the maximum length of %d characters.", paramName, 63));
        }
        Matcher m = HOSTNAME_COMPLIANT_PATTERN.matcher(hostnameComponent);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("An S3 Access Point ARN has been passed that is not valid: the '%s' component must only contain alphanumeric characters and dashes.", paramName));
        }
    }
}

