/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.elasticmapreduce.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonServiceException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import java.util.ArrayList;
import java.util.List;

public class ResizeJobFlowStep {
    private String bucket;
    private List<String> args = new ArrayList<String>();
    private boolean wait = true;
    private OnArrested onArrested = null;
    private OnFailure onFailure = null;

    public ResizeJobFlowStep() {
        this("us-east-1.elasticmapreduce");
    }

    public ResizeJobFlowStep(String bucket) {
        this.bucket = bucket;
    }

    public ResizeJobFlowStep withResizeAction(ResizeAction resizeAction) {
        this.args.addAll(resizeAction.getArgs());
        return this;
    }

    public ResizeJobFlowStep withWait(boolean wait) {
        this.wait = wait;
        return this;
    }

    public ResizeJobFlowStep withOnArrested(OnArrested onArrested) {
        this.onArrested = onArrested;
        return this;
    }

    public ResizeJobFlowStep withOnFailure(OnFailure onFailure) {
        this.onFailure = onFailure;
        return this;
    }

    public HadoopJarStepConfig toHadoopJarStepConfig() {
        if (this.args.size() == 0) {
            throw new AmazonServiceException("Cannot create a ResizeJobFlowStep with no resize actions.");
        }
        if (!this.wait) {
            this.args.add("--no-wait");
        }
        if (this.onArrested != null) {
            this.args.add("--on-arrested");
            this.args.add(this.onArrested.toString());
        }
        if (this.onFailure != null) {
            this.args.add("--on-failure");
            this.args.add(this.onFailure.toString());
        }
        return new HadoopJarStepConfig().withJar("s3://" + this.bucket + "/libs/resize-job-flow/0.1/resize-job-flow.jar").withArgs(this.args);
    }

    public static class AddInstanceGroup
    implements ResizeAction {
        private String instanceGroup;
        private Integer instanceCount;
        private String instanceType;

        public AddInstanceGroup withInstanceGroup(String instanceGroup) {
            this.instanceGroup = instanceGroup;
            return this;
        }

        public AddInstanceGroup withInstanceCount(int instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public AddInstanceGroup withInstanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public List<String> getArgs() {
            if (this.instanceGroup == null) {
                throw new AmazonServiceException("InstanceGroup must not be null.");
            }
            if (this.instanceCount == null) {
                throw new AmazonServiceException("InstanceCount must not be null.");
            }
            if (this.instanceType == null) {
                throw new AmazonServiceException("InstanceType must not be null.");
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("--add-instance-group");
            args.add(this.instanceGroup);
            args.add("--instance-count");
            args.add(Integer.toString(this.instanceCount));
            args.add("--instance-type");
            args.add(this.instanceType);
            return args;
        }
    }

    public static class ModifyInstanceGroup
    implements ResizeAction {
        private String instanceGroup;
        private Integer instanceCount;

        public ModifyInstanceGroup withInstanceGroup(String instanceGroup) {
            this.instanceGroup = instanceGroup;
            return this;
        }

        public ModifyInstanceGroup withInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        @Override
        public List<String> getArgs() {
            if (this.instanceGroup == null) {
                throw new AmazonServiceException("InstanceGroup must not be null.");
            }
            if (this.instanceCount == null) {
                throw new AmazonServiceException("InstanceCount must not be null.");
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("--modify-instance-group");
            args.add(this.instanceGroup);
            args.add("--instance-count");
            args.add(Integer.toString(this.instanceCount));
            return args;
        }
    }

    public static interface ResizeAction {
        public List<String> getArgs();
    }

    public static enum OnFailure {
        Fail,
        Continue;

    }

    public static enum OnArrested {
        Fail,
        Wait,
        Continue;

    }
}

