/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.elasticmapreduce.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.internal.SdkInternalList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.protocol.StructuredPojo;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.elasticmapreduce.model.PortRange;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.elasticmapreduce.model.transform.BlockPublicAccessConfigurationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class BlockPublicAccessConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean blockPublicSecurityGroupRules;
    private SdkInternalList<PortRange> permittedPublicSecurityGroupRuleRanges;

    public void setBlockPublicSecurityGroupRules(Boolean blockPublicSecurityGroupRules) {
        this.blockPublicSecurityGroupRules = blockPublicSecurityGroupRules;
    }

    public Boolean getBlockPublicSecurityGroupRules() {
        return this.blockPublicSecurityGroupRules;
    }

    public BlockPublicAccessConfiguration withBlockPublicSecurityGroupRules(Boolean blockPublicSecurityGroupRules) {
        this.setBlockPublicSecurityGroupRules(blockPublicSecurityGroupRules);
        return this;
    }

    public Boolean isBlockPublicSecurityGroupRules() {
        return this.blockPublicSecurityGroupRules;
    }

    public List<PortRange> getPermittedPublicSecurityGroupRuleRanges() {
        if (this.permittedPublicSecurityGroupRuleRanges == null) {
            this.permittedPublicSecurityGroupRuleRanges = new SdkInternalList();
        }
        return this.permittedPublicSecurityGroupRuleRanges;
    }

    public void setPermittedPublicSecurityGroupRuleRanges(Collection<PortRange> permittedPublicSecurityGroupRuleRanges) {
        if (permittedPublicSecurityGroupRuleRanges == null) {
            this.permittedPublicSecurityGroupRuleRanges = null;
            return;
        }
        this.permittedPublicSecurityGroupRuleRanges = new SdkInternalList<PortRange>(permittedPublicSecurityGroupRuleRanges);
    }

    public BlockPublicAccessConfiguration withPermittedPublicSecurityGroupRuleRanges(PortRange ... permittedPublicSecurityGroupRuleRanges) {
        if (this.permittedPublicSecurityGroupRuleRanges == null) {
            this.setPermittedPublicSecurityGroupRuleRanges(new SdkInternalList<PortRange>(permittedPublicSecurityGroupRuleRanges.length));
        }
        for (PortRange ele : permittedPublicSecurityGroupRuleRanges) {
            this.permittedPublicSecurityGroupRuleRanges.add(ele);
        }
        return this;
    }

    public BlockPublicAccessConfiguration withPermittedPublicSecurityGroupRuleRanges(Collection<PortRange> permittedPublicSecurityGroupRuleRanges) {
        this.setPermittedPublicSecurityGroupRuleRanges(permittedPublicSecurityGroupRuleRanges);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBlockPublicSecurityGroupRules() != null) {
            sb.append("BlockPublicSecurityGroupRules: ").append(this.getBlockPublicSecurityGroupRules()).append(",");
        }
        if (this.getPermittedPublicSecurityGroupRuleRanges() != null) {
            sb.append("PermittedPublicSecurityGroupRuleRanges: ").append(this.getPermittedPublicSecurityGroupRuleRanges());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockPublicAccessConfiguration)) {
            return false;
        }
        BlockPublicAccessConfiguration other = (BlockPublicAccessConfiguration)obj;
        if (other.getBlockPublicSecurityGroupRules() == null ^ this.getBlockPublicSecurityGroupRules() == null) {
            return false;
        }
        if (other.getBlockPublicSecurityGroupRules() != null && !other.getBlockPublicSecurityGroupRules().equals(this.getBlockPublicSecurityGroupRules())) {
            return false;
        }
        if (other.getPermittedPublicSecurityGroupRuleRanges() == null ^ this.getPermittedPublicSecurityGroupRuleRanges() == null) {
            return false;
        }
        return other.getPermittedPublicSecurityGroupRuleRanges() == null || other.getPermittedPublicSecurityGroupRuleRanges().equals(this.getPermittedPublicSecurityGroupRuleRanges());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBlockPublicSecurityGroupRules() == null ? 0 : this.getBlockPublicSecurityGroupRules().hashCode());
        hashCode = 31 * hashCode + (this.getPermittedPublicSecurityGroupRuleRanges() == null ? 0 : this.getPermittedPublicSecurityGroupRuleRanges().hashCode());
        return hashCode;
    }

    public BlockPublicAccessConfiguration clone() {
        try {
            return (BlockPublicAccessConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlockPublicAccessConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

