/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.elasticmapreduce.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.internal.SdkInternalList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.protocol.StructuredPojo;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.elasticmapreduce.model.AutoScalingPolicyStatus;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.elasticmapreduce.model.ScalingConstraints;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.elasticmapreduce.model.ScalingRule;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.elasticmapreduce.model.transform.AutoScalingPolicyDescriptionMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AutoScalingPolicyDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private AutoScalingPolicyStatus status;
    private ScalingConstraints constraints;
    private SdkInternalList<ScalingRule> rules;

    public void setStatus(AutoScalingPolicyStatus status) {
        this.status = status;
    }

    public AutoScalingPolicyStatus getStatus() {
        return this.status;
    }

    public AutoScalingPolicyDescription withStatus(AutoScalingPolicyStatus status) {
        this.setStatus(status);
        return this;
    }

    public void setConstraints(ScalingConstraints constraints) {
        this.constraints = constraints;
    }

    public ScalingConstraints getConstraints() {
        return this.constraints;
    }

    public AutoScalingPolicyDescription withConstraints(ScalingConstraints constraints) {
        this.setConstraints(constraints);
        return this;
    }

    public List<ScalingRule> getRules() {
        if (this.rules == null) {
            this.rules = new SdkInternalList();
        }
        return this.rules;
    }

    public void setRules(Collection<ScalingRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new SdkInternalList<ScalingRule>(rules);
    }

    public AutoScalingPolicyDescription withRules(ScalingRule ... rules) {
        if (this.rules == null) {
            this.setRules(new SdkInternalList<ScalingRule>(rules.length));
        }
        for (ScalingRule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public AutoScalingPolicyDescription withRules(Collection<ScalingRule> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getConstraints() != null) {
            sb.append("Constraints: ").append(this.getConstraints()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicyDescription)) {
            return false;
        }
        AutoScalingPolicyDescription other = (AutoScalingPolicyDescription)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getConstraints() == null ^ this.getConstraints() == null) {
            return false;
        }
        if (other.getConstraints() != null && !other.getConstraints().equals(this.getConstraints())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getConstraints() == null ? 0 : this.getConstraints().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public AutoScalingPolicyDescription clone() {
        try {
            return (AutoScalingPolicyDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingPolicyDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

