/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.waiters;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonServiceException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.jmespath.JmesPathExpression;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.jmespath.JmesPathField;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.jmespath.JmesPathSubExpression;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.jmespath.JmesPathVisitor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.waiters.WaiterAcceptor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.waiters.WaiterState;
import com.amazon.ws.emr.hadoop.fs.shaded.com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class TableExists {
    TableExists() {
    }

    static class IsResourceNotFoundExceptionMatcher
    extends WaiterAcceptor<DescribeTableResult> {
        IsResourceNotFoundExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ResourceNotFoundException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsACTIVEMatcher
    extends WaiterAcceptor<DescribeTableResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsACTIVEMatcher() {
        }

        @Override
        public boolean matches(DescribeTableResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"ACTIVE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathExpression[]{new JmesPathField("Table"), new JmesPathField("TableStatus")});
        }
    }
}

