/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.transform;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.SdkClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.protocol.MarshallLocation;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.protocol.MarshallingType;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ArchivalSummary;
import java.util.Date;

@SdkInternalApi
public class ArchivalSummaryMarshaller {
    private static final MarshallingInfo<Date> ARCHIVALDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchivalDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ARCHIVALREASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchivalReason").build();
    private static final MarshallingInfo<String> ARCHIVALBACKUPARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchivalBackupArn").build();
    private static final ArchivalSummaryMarshaller instance = new ArchivalSummaryMarshaller();

    public static ArchivalSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(ArchivalSummary archivalSummary, ProtocolMarshaller protocolMarshaller) {
        if (archivalSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(archivalSummary.getArchivalDateTime(), ARCHIVALDATETIME_BINDING);
            protocolMarshaller.marshall(archivalSummary.getArchivalReason(), ARCHIVALREASON_BINDING);
            protocolMarshaller.marshall(archivalSummary.getArchivalBackupArn(), ARCHIVALBACKUPARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

