/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonWebServiceResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.ResponseMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactWriteItemsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ConsumedCapacity> consumedCapacity;
    private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;

    public List<ConsumedCapacity> getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
        if (consumedCapacity == null) {
            this.consumedCapacity = null;
            return;
        }
        this.consumedCapacity = new ArrayList<ConsumedCapacity>(consumedCapacity);
    }

    public TransactWriteItemsResult withConsumedCapacity(ConsumedCapacity ... consumedCapacity) {
        if (this.consumedCapacity == null) {
            this.setConsumedCapacity(new ArrayList<ConsumedCapacity>(consumedCapacity.length));
        }
        for (ConsumedCapacity ele : consumedCapacity) {
            this.consumedCapacity.add(ele);
        }
        return this;
    }

    public TransactWriteItemsResult withConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
        this.setConsumedCapacity(consumedCapacity);
        return this;
    }

    public Map<String, List<ItemCollectionMetrics>> getItemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public void setItemCollectionMetrics(Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics) {
        this.itemCollectionMetrics = itemCollectionMetrics;
    }

    public TransactWriteItemsResult withItemCollectionMetrics(Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics) {
        this.setItemCollectionMetrics(itemCollectionMetrics);
        return this;
    }

    public TransactWriteItemsResult addItemCollectionMetricsEntry(String key, List<ItemCollectionMetrics> value) {
        if (null == this.itemCollectionMetrics) {
            this.itemCollectionMetrics = new HashMap<String, List<ItemCollectionMetrics>>();
        }
        if (this.itemCollectionMetrics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.itemCollectionMetrics.put(key, value);
        return this;
    }

    public TransactWriteItemsResult clearItemCollectionMetricsEntries() {
        this.itemCollectionMetrics = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConsumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(this.getConsumedCapacity()).append(",");
        }
        if (this.getItemCollectionMetrics() != null) {
            sb.append("ItemCollectionMetrics: ").append(this.getItemCollectionMetrics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactWriteItemsResult)) {
            return false;
        }
        TransactWriteItemsResult other = (TransactWriteItemsResult)obj;
        if (other.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        if (other.getConsumedCapacity() != null && !other.getConsumedCapacity().equals(this.getConsumedCapacity())) {
            return false;
        }
        if (other.getItemCollectionMetrics() == null ^ this.getItemCollectionMetrics() == null) {
            return false;
        }
        return other.getItemCollectionMetrics() == null || other.getItemCollectionMetrics().equals(this.getItemCollectionMetrics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConsumedCapacity() == null ? 0 : this.getConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getItemCollectionMetrics() == null ? 0 : this.getItemCollectionMetrics().hashCode());
        return hashCode;
    }

    public TransactWriteItemsResult clone() {
        try {
            return (TransactWriteItemsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

