/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonWebServiceRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ReturnItemCollectionMetrics;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.TransactWriteItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TransactWriteItemsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<TransactWriteItem> transactItems;
    private String returnConsumedCapacity;
    private String returnItemCollectionMetrics;
    private String clientRequestToken;

    public List<TransactWriteItem> getTransactItems() {
        return this.transactItems;
    }

    public void setTransactItems(Collection<TransactWriteItem> transactItems) {
        if (transactItems == null) {
            this.transactItems = null;
            return;
        }
        this.transactItems = new ArrayList<TransactWriteItem>(transactItems);
    }

    public TransactWriteItemsRequest withTransactItems(TransactWriteItem ... transactItems) {
        if (this.transactItems == null) {
            this.setTransactItems(new ArrayList<TransactWriteItem>(transactItems.length));
        }
        for (TransactWriteItem ele : transactItems) {
            this.transactItems.add(ele);
        }
        return this;
    }

    public TransactWriteItemsRequest withTransactItems(Collection<TransactWriteItem> transactItems) {
        this.setTransactItems(transactItems);
        return this;
    }

    public void setReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public TransactWriteItemsRequest withReturnConsumedCapacity(String returnConsumedCapacity) {
        this.setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    public TransactWriteItemsRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics;
    }

    public String getReturnItemCollectionMetrics() {
        return this.returnItemCollectionMetrics;
    }

    public TransactWriteItemsRequest withReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
        this.setReturnItemCollectionMetrics(returnItemCollectionMetrics);
        return this;
    }

    public TransactWriteItemsRequest withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics.toString();
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public TransactWriteItemsRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTransactItems() != null) {
            sb.append("TransactItems: ").append(this.getTransactItems()).append(",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.getReturnConsumedCapacity()).append(",");
        }
        if (this.getReturnItemCollectionMetrics() != null) {
            sb.append("ReturnItemCollectionMetrics: ").append(this.getReturnItemCollectionMetrics()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactWriteItemsRequest)) {
            return false;
        }
        TransactWriteItemsRequest other = (TransactWriteItemsRequest)obj;
        if (other.getTransactItems() == null ^ this.getTransactItems() == null) {
            return false;
        }
        if (other.getTransactItems() != null && !other.getTransactItems().equals(this.getTransactItems())) {
            return false;
        }
        if (other.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        if (other.getReturnConsumedCapacity() != null && !other.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity())) {
            return false;
        }
        if (other.getReturnItemCollectionMetrics() == null ^ this.getReturnItemCollectionMetrics() == null) {
            return false;
        }
        if (other.getReturnItemCollectionMetrics() != null && !other.getReturnItemCollectionMetrics().equals(this.getReturnItemCollectionMetrics())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        return other.getClientRequestToken() == null || other.getClientRequestToken().equals(this.getClientRequestToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTransactItems() == null ? 0 : this.getTransactItems().hashCode());
        hashCode = 31 * hashCode + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getReturnItemCollectionMetrics() == null ? 0 : this.getReturnItemCollectionMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        return hashCode;
    }

    @Override
    public TransactWriteItemsRequest clone() {
        return (TransactWriteItemsRequest)super.clone();
    }
}

