/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.spec;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.annotation.Beta;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.event.ProgressListener;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.metrics.RequestMetricCollector;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.Expected;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.Item;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.spec.AbstractSpec;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ReturnItemCollectionMetrics;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.xspec.PutItemExpressionSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class PutItemSpec
extends AbstractSpec<PutItemRequest> {
    private Item item;
    private Collection<Expected> expected;
    private Map<String, String> nameMap;
    private Map<String, Object> valueMap;

    public PutItemSpec() {
        super(new PutItemRequest());
    }

    public Item getItem() {
        return this.item;
    }

    public PutItemSpec withItem(Item item) {
        this.item = item;
        return this;
    }

    public Collection<Expected> getExpected() {
        return this.expected;
    }

    public PutItemSpec withExpected(Expected ... expected) {
        if (expected == null) {
            this.expected = null;
            return this;
        }
        return this.withExpected(Arrays.asList(expected));
    }

    public PutItemSpec withExpected(Collection<Expected> expected) {
        if (expected == null) {
            this.expected = null;
            return this;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Expected e : expected) {
            names.add(e.getAttribute());
        }
        if (names.size() != expected.size()) {
            throw new IllegalArgumentException("attribute names must not duplicate in the list of expected");
        }
        this.expected = Collections.unmodifiableCollection(expected);
        return this;
    }

    public String getConditionExpression() {
        return ((PutItemRequest)this.getRequest()).getConditionExpression();
    }

    public PutItemSpec withConditionExpression(String conditionExpression) {
        ((PutItemRequest)this.getRequest()).setConditionExpression(conditionExpression);
        return this;
    }

    public Map<String, String> getNameMap() {
        return this.nameMap;
    }

    public PutItemSpec withNameMap(Map<String, String> nameMap) {
        this.nameMap = nameMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, String>(nameMap));
        return this;
    }

    public Map<String, Object> getValueMap() {
        return this.valueMap;
    }

    public PutItemSpec withValueMap(Map<String, Object> valueMap) {
        this.valueMap = valueMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(valueMap));
        return this;
    }

    public String getConditionalOperator() {
        return ((PutItemRequest)this.getRequest()).getConditionalOperator();
    }

    public PutItemSpec withConditionalOperator(ConditionalOperator conditionalOperator) {
        ((PutItemRequest)this.getRequest()).setConditionalOperator(conditionalOperator);
        return this;
    }

    public String getReturnConsumedCapacity() {
        return ((PutItemRequest)this.getRequest()).getReturnConsumedCapacity();
    }

    public PutItemSpec withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        ((PutItemRequest)this.getRequest()).setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    public String getReturnItemCollectionMetrics() {
        return ((PutItemRequest)this.getRequest()).getReturnItemCollectionMetrics();
    }

    public PutItemSpec withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        ((PutItemRequest)this.getRequest()).setReturnItemCollectionMetrics(returnItemCollectionMetrics);
        return this;
    }

    public String getReturnValues() {
        return ((PutItemRequest)this.getRequest()).getReturnValues();
    }

    public PutItemSpec withReturnValues(ReturnValue returnValues) {
        ((PutItemRequest)this.getRequest()).setReturnValues(returnValues);
        return this;
    }

    public PutItemSpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    public PutItemSpec withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.setRequestMetricCollector(requestMetricCollector);
        return this;
    }

    @Beta
    public PutItemSpec withExpressionSpec(PutItemExpressionSpec xspec) {
        return this.withConditionExpression(xspec.getConditionExpression()).withNameMap(xspec.getNameMap()).withValueMap(xspec.getValueMap());
    }
}

