/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.Item;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.Page;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.QueryOutcome;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.internal.QueryPage;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.QueryResult;
import java.util.LinkedHashMap;
import java.util.Map;

class QueryCollection
extends ItemCollection<QueryOutcome> {
    private final AmazonDynamoDB client;
    private final QuerySpec spec;
    private final Map<String, AttributeValue> startKey;

    public QueryCollection(AmazonDynamoDB client, QuerySpec spec) {
        this.client = client;
        this.spec = spec;
        Map<String, AttributeValue> startKey = ((QueryRequest)spec.getRequest()).getExclusiveStartKey();
        this.startKey = startKey == null ? null : new LinkedHashMap<String, AttributeValue>(startKey);
    }

    @Override
    public Page<Item, QueryOutcome> firstPage() {
        QueryRequest request = (QueryRequest)this.spec.getRequest();
        request.setExclusiveStartKey(this.startKey);
        request.setLimit(InternalUtils.minimum(this.spec.getMaxResultSize(), this.spec.getMaxPageSize()));
        QueryResult result = this.client.query(request);
        QueryOutcome outcome = new QueryOutcome(result);
        this.setLastLowLevelResult(outcome);
        return new QueryPage(this.client, this.spec, request, 0, outcome);
    }

    @Override
    public Integer getMaxResultSize() {
        return this.spec.getMaxResultSize();
    }

    @Override
    protected void setLastLowLevelResult(QueryOutcome lowLevelResult) {
        super.setLastLowLevelResult(lowLevelResult);
        QueryResult result = lowLevelResult.getQueryResult();
        this.accumulateStats(result.getConsumedCapacity(), result.getCount(), result.getScannedCount());
    }
}

