/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.Page;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.internal.PageBasedCollection;
import java.util.Iterator;

class PageIterator<T, R>
implements Iterator<Page<T, R>> {
    private Page<T, R> page;
    private final PageBasedCollection<T, R> col;

    PageIterator(PageBasedCollection<T, R> col) {
        this.col = col;
    }

    @Override
    public boolean hasNext() {
        Integer max = this.col.getMaxResultSize();
        if (max != null && max <= 0) {
            return false;
        }
        return this.page == null || this.page.hasNextPage();
    }

    @Override
    public Page<T, R> next() {
        if (this.page == null) {
            this.page = this.col.firstPage();
        } else {
            this.page = this.page.nextPage();
            this.col.setLastLowLevelResult(this.page.getLowLevelResult());
        }
        return this.page;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Collection is read-only");
    }
}

