/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ComparisonOperator;

public abstract class Filter<T extends Filter<T>> {
    private final String attribute;
    private ComparisonOperator op;
    private Object[] values;

    protected Filter(String attrName) {
        InternalUtils.checkInvalidAttrName(attrName);
        this.attribute = attrName;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public ComparisonOperator getComparisonOperator() {
        return this.op;
    }

    public Object[] getValues() {
        return this.values == null ? null : (Object[])this.values.clone();
    }

    protected T _withValues(Object ... values) {
        this.values = (Object[])values.clone();
        return (T)this;
    }

    private T _withComparisonOperator(ComparisonOperator op) {
        this.op = op;
        return (T)this;
    }

    public T eq(Object val) {
        return ((Filter)this._withComparisonOperator(ComparisonOperator.EQ))._withValues(val);
    }

    public T ne(Object val) {
        return ((Filter)this._withComparisonOperator(ComparisonOperator.NE))._withValues(val);
    }

    public T exists() {
        return this._withComparisonOperator(ComparisonOperator.NOT_NULL);
    }

    public T notExist() {
        return this._withComparisonOperator(ComparisonOperator.NULL);
    }

    public T contains(Object val) {
        return ((Filter)this._withComparisonOperator(ComparisonOperator.CONTAINS))._withValues(val);
    }

    public T notContains(Object val) {
        return ((Filter)this._withComparisonOperator(ComparisonOperator.NOT_CONTAINS))._withValues(val);
    }

    public T beginsWith(String val) {
        return ((Filter)this._withComparisonOperator(ComparisonOperator.BEGINS_WITH))._withValues(val);
    }

    public T in(Object ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("values must not be null or empty.");
        }
        return ((Filter)this._withComparisonOperator(ComparisonOperator.IN))._withValues(values);
    }

    public T between(Object low, Object hi) {
        return ((Filter)this._withComparisonOperator(ComparisonOperator.BETWEEN))._withValues(low, hi);
    }

    public T ge(Object val) {
        return ((Filter)this._withComparisonOperator(ComparisonOperator.GE))._withValues(val);
    }

    public T gt(Object val) {
        return ((Filter)this._withComparisonOperator(ComparisonOperator.GT))._withValues(val);
    }

    public T le(Object val) {
        return ((Filter)this._withComparisonOperator(ComparisonOperator.LE))._withValues(val);
    }

    public T lt(Object val) {
        return ((Filter)this._withComparisonOperator(ComparisonOperator.LT))._withValues(val);
    }
}

