/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.Item;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BatchGetItemOutcome {
    private final BatchGetItemResult result;

    public BatchGetItemOutcome(BatchGetItemResult result) {
        if (result == null) {
            throw new IllegalArgumentException();
        }
        this.result = result;
    }

    public Map<String, List<Item>> getTableItems() {
        Map<String, List<Map<String, AttributeValue>>> res = this.result.getResponses();
        LinkedHashMap<String, List<Item>> map = new LinkedHashMap<String, List<Item>>(res.size());
        for (Map.Entry<String, List<Map<String, AttributeValue>>> e : res.entrySet()) {
            String tableName = e.getKey();
            List<Map<String, AttributeValue>> items = e.getValue();
            map.put(tableName, InternalUtils.toItemList(items));
        }
        return map;
    }

    public Map<String, KeysAndAttributes> getUnprocessedKeys() {
        return this.result.getUnprocessedKeys();
    }

    public BatchGetItemResult getBatchGetItemResult() {
        return this.result;
    }

    public String toString() {
        return String.valueOf(this.result);
    }
}

