/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.PaginatedList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.ParallelScanTask;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.LinkedList;
import java.util.List;

public class PaginatedParallelScanList<T>
extends PaginatedList<T> {
    private final ParallelScanTask parallelScanTask;
    private final DynamoDBMapperConfig config;

    public PaginatedParallelScanList(DynamoDBMapper mapper, Class<T> clazz, AmazonDynamoDB dynamo, ParallelScanTask parallelScanTask, DynamoDBMapperConfig.PaginationLoadingStrategy paginationLoadingStrategy, DynamoDBMapperConfig config) {
        super(mapper, clazz, dynamo, paginationLoadingStrategy);
        this.parallelScanTask = parallelScanTask;
        this.config = config;
        this.allResults.addAll(this.marshalParallelScanResultsIntoObjects(parallelScanTask.getNextBatchOfScanResults()));
        if (paginationLoadingStrategy == DynamoDBMapperConfig.PaginationLoadingStrategy.EAGER_LOADING) {
            this.loadAllResults();
        }
    }

    @Override
    protected boolean atEndOfResults() {
        return this.parallelScanTask.isAllSegmentScanFinished();
    }

    @Override
    protected List<T> fetchNextPage() {
        return this.marshalParallelScanResultsIntoObjects(this.parallelScanTask.getNextBatchOfScanResults());
    }

    private List<T> marshalParallelScanResultsIntoObjects(List<ScanResult> scanResults) {
        LinkedList allItems = new LinkedList();
        for (ScanResult scanResult : scanResults) {
            if (null == scanResult) continue;
            allItems.addAll(this.mapper.marshallIntoObjects(this.mapper.toParameters(scanResult.getItems(), this.clazz, this.parallelScanTask.getTableName(), this.config)));
        }
        return allItems;
    }
}

