/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.transform;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.DefaultRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.Request;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.SdkClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.http.HttpMethodName;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.internal.SdkInternalList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.GetInsightRuleReportRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.Marshaller;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.util.StringUtils;

public class GetInsightRuleReportRequestMarshaller
implements Marshaller<Request<GetInsightRuleReportRequest>, GetInsightRuleReportRequest> {
    @Override
    public Request<GetInsightRuleReportRequest> marshall(GetInsightRuleReportRequest getInsightRuleReportRequest) {
        if (getInsightRuleReportRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetInsightRuleReportRequest> request = new DefaultRequest<GetInsightRuleReportRequest>(getInsightRuleReportRequest, "AmazonCloudWatch");
        request.addParameter("Action", "GetInsightRuleReport");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getInsightRuleReportRequest.getRuleName() != null) {
            request.addParameter("RuleName", StringUtils.fromString(getInsightRuleReportRequest.getRuleName()));
        }
        if (getInsightRuleReportRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate(getInsightRuleReportRequest.getStartTime()));
        }
        if (getInsightRuleReportRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate(getInsightRuleReportRequest.getEndTime()));
        }
        if (getInsightRuleReportRequest.getPeriod() != null) {
            request.addParameter("Period", StringUtils.fromInteger(getInsightRuleReportRequest.getPeriod()));
        }
        if (getInsightRuleReportRequest.getMaxContributorCount() != null) {
            request.addParameter("MaxContributorCount", StringUtils.fromInteger(getInsightRuleReportRequest.getMaxContributorCount()));
        }
        if (!getInsightRuleReportRequest.getMetrics().isEmpty() || !((SdkInternalList)getInsightRuleReportRequest.getMetrics()).isAutoConstruct()) {
            SdkInternalList metricsList = (SdkInternalList)getInsightRuleReportRequest.getMetrics();
            int metricsListIndex = 1;
            for (String metricsListValue : metricsList) {
                if (metricsListValue != null) {
                    request.addParameter("Metrics.member." + metricsListIndex, StringUtils.fromString(metricsListValue));
                }
                ++metricsListIndex;
            }
        }
        if (getInsightRuleReportRequest.getOrderBy() != null) {
            request.addParameter("OrderBy", StringUtils.fromString(getInsightRuleReportRequest.getOrderBy()));
        }
        return request;
    }
}

