/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.transform;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.DimensionFilter;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DimensionFilterStaxUnmarshaller
implements Unmarshaller<DimensionFilter, StaxUnmarshallerContext> {
    private static DimensionFilterStaxUnmarshaller instance;

    @Override
    public DimensionFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        DimensionFilter dimensionFilter = new DimensionFilter();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dimensionFilter;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    dimensionFilter.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Value", targetDepth)) continue;
                dimensionFilter.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dimensionFilter;
    }

    public static DimensionFilterStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DimensionFilterStaxUnmarshaller();
        }
        return instance;
    }
}

