/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.transform;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.DashboardEntry;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DashboardEntryStaxUnmarshaller
implements Unmarshaller<DashboardEntry, StaxUnmarshallerContext> {
    private static DashboardEntryStaxUnmarshaller instance;

    @Override
    public DashboardEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        DashboardEntry dashboardEntry = new DashboardEntry();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dashboardEntry;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DashboardName", targetDepth)) {
                    dashboardEntry.setDashboardName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DashboardArn", targetDepth)) {
                    dashboardEntry.setDashboardArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LastModified", targetDepth)) {
                    dashboardEntry.setLastModified(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Size", targetDepth)) continue;
                dashboardEntry.setSize(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dashboardEntry;
    }

    public static DashboardEntryStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DashboardEntryStaxUnmarshaller();
        }
        return instance;
    }
}

