/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor.RequestExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.Secret;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.UpdateSecretResponse;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.utils.URIBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;

public class UpdateSecretRequest
implements SecretAgentRequest<UpdateSecretResponse> {
    Secret secret;
    boolean enableUserAuthenticatedNamespaces;
    @Nullable
    private String requestingUser;

    @Override
    public URI getURI(URI baseUri) throws URISyntaxException {
        return new URIBuilder(baseUri).setPath(String.format("/v1/secrets/%s", this.secret.getName())).build();
    }

    @Override
    public RequestExecutor.HttpVerb getHttpVerb() {
        return RequestExecutor.HttpVerb.PUT;
    }

    @Override
    public boolean isPathOnly() {
        return false;
    }

    @Override
    public Class<UpdateSecretResponse> getResponseType() {
        return UpdateSecretResponse.class;
    }

    public static UpdateSecretRequestBuilder builder() {
        return new UpdateSecretRequestBuilder();
    }

    public UpdateSecretRequest(Secret secret, boolean enableUserAuthenticatedNamespaces, @Nullable String requestingUser) {
        this.secret = secret;
        this.enableUserAuthenticatedNamespaces = enableUserAuthenticatedNamespaces;
        this.requestingUser = requestingUser;
    }

    public UpdateSecretRequest() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateSecretRequest)) {
            return false;
        }
        UpdateSecretRequest other = (UpdateSecretRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Secret this$secret = this.getSecret();
        Secret other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !((Object)this$secret).equals(other$secret)) {
            return false;
        }
        if (this.isEnableUserAuthenticatedNamespaces() != other.isEnableUserAuthenticatedNamespaces()) {
            return false;
        }
        String this$requestingUser = this.getRequestingUser();
        String other$requestingUser = other.getRequestingUser();
        return !(this$requestingUser == null ? other$requestingUser != null : !this$requestingUser.equals(other$requestingUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateSecretRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Secret $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : ((Object)$secret).hashCode());
        result = result * 59 + (this.isEnableUserAuthenticatedNamespaces() ? 79 : 97);
        String $requestingUser = this.getRequestingUser();
        result = result * 59 + ($requestingUser == null ? 43 : $requestingUser.hashCode());
        return result;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public boolean isEnableUserAuthenticatedNamespaces() {
        return this.enableUserAuthenticatedNamespaces;
    }

    @Nullable
    public String getRequestingUser() {
        return this.requestingUser;
    }

    public void setSecret(Secret secret) {
        this.secret = secret;
    }

    public void setEnableUserAuthenticatedNamespaces(boolean enableUserAuthenticatedNamespaces) {
        this.enableUserAuthenticatedNamespaces = enableUserAuthenticatedNamespaces;
    }

    public void setRequestingUser(@Nullable String requestingUser) {
        this.requestingUser = requestingUser;
    }

    public static class UpdateSecretRequestBuilder {
        private Secret secret;
        private boolean enableUserAuthenticatedNamespaces;
        private String requestingUser;

        UpdateSecretRequestBuilder() {
        }

        public UpdateSecretRequestBuilder secret(Secret secret) {
            this.secret = secret;
            return this;
        }

        public UpdateSecretRequestBuilder enableUserAuthenticatedNamespaces(boolean enableUserAuthenticatedNamespaces) {
            this.enableUserAuthenticatedNamespaces = enableUserAuthenticatedNamespaces;
            return this;
        }

        public UpdateSecretRequestBuilder requestingUser(@Nullable String requestingUser) {
            this.requestingUser = requestingUser;
            return this;
        }

        public UpdateSecretRequest build() {
            return new UpdateSecretRequest(this.secret, this.enableUserAuthenticatedNamespaces, this.requestingUser);
        }

        public String toString() {
            return "UpdateSecretRequest.UpdateSecretRequestBuilder(secret=" + this.secret + ", enableUserAuthenticatedNamespaces=" + this.enableUserAuthenticatedNamespaces + ", requestingUser=" + this.requestingUser + ")";
        }
    }
}

