/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.adapter.GsonFactory;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.adapter.ZonedDateTimeXmlAdapter;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretStrings;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class TemporaryCredentials {
    private static final Gson GSON = GsonFactory.createGson();
    private String awsAccessKeyId;
    private String awsSecretKey;
    private String sessionToken;
    @XmlJavaTypeAdapter(value=ZonedDateTimeXmlAdapter.class)
    private ZonedDateTime expiration;

    public String toString() {
        return "TemporaryCredentials{awsAccessKeyId='" + this.awsAccessKeyId + '\'' + ", awsSecretKey='" + SecretStrings.mask(this.awsSecretKey) + '\'' + ", sessionToken='" + SecretStrings.mask(this.sessionToken) + '\'' + ", expiration=" + this.expiration + '}';
    }

    public byte[] toBytes() {
        return GSON.toJson(this).getBytes(StandardCharsets.UTF_8);
    }

    public static TemporaryCredentials fromBytes(byte[] bytes) {
        return GSON.fromJson(new String(bytes, StandardCharsets.UTF_8), TemporaryCredentials.class);
    }

    public static TemporaryCredentialsBuilder builder() {
        return new TemporaryCredentialsBuilder();
    }

    public TemporaryCredentialsBuilder toBuilder() {
        return new TemporaryCredentialsBuilder().awsAccessKeyId(this.awsAccessKeyId).awsSecretKey(this.awsSecretKey).sessionToken(this.sessionToken).expiration(this.expiration);
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public ZonedDateTime getExpiration() {
        return this.expiration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemporaryCredentials)) {
            return false;
        }
        TemporaryCredentials other = (TemporaryCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$awsAccessKeyId = this.getAwsAccessKeyId();
        String other$awsAccessKeyId = other.getAwsAccessKeyId();
        if (this$awsAccessKeyId == null ? other$awsAccessKeyId != null : !this$awsAccessKeyId.equals(other$awsAccessKeyId)) {
            return false;
        }
        String this$awsSecretKey = this.getAwsSecretKey();
        String other$awsSecretKey = other.getAwsSecretKey();
        if (this$awsSecretKey == null ? other$awsSecretKey != null : !this$awsSecretKey.equals(other$awsSecretKey)) {
            return false;
        }
        String this$sessionToken = this.getSessionToken();
        String other$sessionToken = other.getSessionToken();
        if (this$sessionToken == null ? other$sessionToken != null : !this$sessionToken.equals(other$sessionToken)) {
            return false;
        }
        ZonedDateTime this$expiration = this.getExpiration();
        ZonedDateTime other$expiration = other.getExpiration();
        return !(this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemporaryCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $awsAccessKeyId = this.getAwsAccessKeyId();
        result = result * 59 + ($awsAccessKeyId == null ? 43 : $awsAccessKeyId.hashCode());
        String $awsSecretKey = this.getAwsSecretKey();
        result = result * 59 + ($awsSecretKey == null ? 43 : $awsSecretKey.hashCode());
        String $sessionToken = this.getSessionToken();
        result = result * 59 + ($sessionToken == null ? 43 : $sessionToken.hashCode());
        ZonedDateTime $expiration = this.getExpiration();
        result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
        return result;
    }

    public TemporaryCredentials() {
    }

    public TemporaryCredentials(String awsAccessKeyId, String awsSecretKey, String sessionToken, ZonedDateTime expiration) {
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretKey = awsSecretKey;
        this.sessionToken = sessionToken;
        this.expiration = expiration;
    }

    public static class TemporaryCredentialsBuilder {
        private String awsAccessKeyId;
        private String awsSecretKey;
        private String sessionToken;
        private ZonedDateTime expiration;

        TemporaryCredentialsBuilder() {
        }

        public TemporaryCredentialsBuilder awsAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
            return this;
        }

        public TemporaryCredentialsBuilder awsSecretKey(String awsSecretKey) {
            this.awsSecretKey = awsSecretKey;
            return this;
        }

        public TemporaryCredentialsBuilder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public TemporaryCredentialsBuilder expiration(ZonedDateTime expiration) {
            this.expiration = expiration;
            return this;
        }

        public TemporaryCredentials build() {
            return new TemporaryCredentials(this.awsAccessKeyId, this.awsSecretKey, this.sessionToken, this.expiration);
        }

        public String toString() {
            return "TemporaryCredentials.TemporaryCredentialsBuilder(awsAccessKeyId=" + this.awsAccessKeyId + ", awsSecretKey=" + this.awsSecretKey + ", sessionToken=" + this.sessionToken + ", expiration=" + this.expiration + ")";
        }
    }
}

