/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor.RequestExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.StoreUserCredentialResponse;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.TemporaryCredentials;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.utils.URIBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import lombok.NonNull;

public class StoreUserCredentialRequest
implements SecretAgentRequest<StoreUserCredentialResponse> {
    @NonNull
    private String username;
    @NonNull
    private List<String> adminUsers;
    boolean metadataCredentials;
    @NonNull
    private TemporaryCredentials temporaryCredentials;

    @Override
    public URI getURI(URI baseUri) throws URISyntaxException {
        return new URIBuilder(baseUri).setPath(String.format("/v1/userCredentials/%s", this.username)).build();
    }

    @Override
    public RequestExecutor.HttpVerb getHttpVerb() {
        return RequestExecutor.HttpVerb.POST;
    }

    @Override
    public boolean isPathOnly() {
        return false;
    }

    @Override
    public Class<StoreUserCredentialResponse> getResponseType() {
        return StoreUserCredentialResponse.class;
    }

    public String toString() {
        return "StoreUserCredentialRequest{username='" + this.username + '\'' + ", adminUsers=" + this.adminUsers + ", temporaryCredentials=" + this.temporaryCredentials + ", metadataCredentials=" + this.metadataCredentials + '}';
    }

    public static StoreUserCredentialRequestBuilder builder() {
        return new StoreUserCredentialRequestBuilder();
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @NonNull
    public List<String> getAdminUsers() {
        return this.adminUsers;
    }

    public boolean isMetadataCredentials() {
        return this.metadataCredentials;
    }

    @NonNull
    public TemporaryCredentials getTemporaryCredentials() {
        return this.temporaryCredentials;
    }

    public void setUsername(@NonNull String username) {
        if (username == null) {
            throw new NullPointerException("username is marked @NonNull but is null");
        }
        this.username = username;
    }

    public void setAdminUsers(@NonNull List<String> adminUsers) {
        if (adminUsers == null) {
            throw new NullPointerException("adminUsers is marked @NonNull but is null");
        }
        this.adminUsers = adminUsers;
    }

    public void setMetadataCredentials(boolean metadataCredentials) {
        this.metadataCredentials = metadataCredentials;
    }

    public void setTemporaryCredentials(@NonNull TemporaryCredentials temporaryCredentials) {
        if (temporaryCredentials == null) {
            throw new NullPointerException("temporaryCredentials is marked @NonNull but is null");
        }
        this.temporaryCredentials = temporaryCredentials;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoreUserCredentialRequest)) {
            return false;
        }
        StoreUserCredentialRequest other = (StoreUserCredentialRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        List<String> this$adminUsers = this.getAdminUsers();
        List<String> other$adminUsers = other.getAdminUsers();
        if (this$adminUsers == null ? other$adminUsers != null : !((Object)this$adminUsers).equals(other$adminUsers)) {
            return false;
        }
        if (this.isMetadataCredentials() != other.isMetadataCredentials()) {
            return false;
        }
        TemporaryCredentials this$temporaryCredentials = this.getTemporaryCredentials();
        TemporaryCredentials other$temporaryCredentials = other.getTemporaryCredentials();
        return !(this$temporaryCredentials == null ? other$temporaryCredentials != null : !((Object)this$temporaryCredentials).equals(other$temporaryCredentials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoreUserCredentialRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        List<String> $adminUsers = this.getAdminUsers();
        result = result * 59 + ($adminUsers == null ? 43 : ((Object)$adminUsers).hashCode());
        result = result * 59 + (this.isMetadataCredentials() ? 79 : 97);
        TemporaryCredentials $temporaryCredentials = this.getTemporaryCredentials();
        result = result * 59 + ($temporaryCredentials == null ? 43 : ((Object)$temporaryCredentials).hashCode());
        return result;
    }

    public StoreUserCredentialRequest() {
    }

    public StoreUserCredentialRequest(@NonNull String username, @NonNull List<String> adminUsers, boolean metadataCredentials, @NonNull TemporaryCredentials temporaryCredentials) {
        if (username == null) {
            throw new NullPointerException("username is marked @NonNull but is null");
        }
        if (adminUsers == null) {
            throw new NullPointerException("adminUsers is marked @NonNull but is null");
        }
        if (temporaryCredentials == null) {
            throw new NullPointerException("temporaryCredentials is marked @NonNull but is null");
        }
        this.username = username;
        this.adminUsers = adminUsers;
        this.metadataCredentials = metadataCredentials;
        this.temporaryCredentials = temporaryCredentials;
    }

    public static class StoreUserCredentialRequestBuilder {
        private String username;
        private List<String> adminUsers;
        private boolean metadataCredentials;
        private TemporaryCredentials temporaryCredentials;

        StoreUserCredentialRequestBuilder() {
        }

        public StoreUserCredentialRequestBuilder username(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked @NonNull but is null");
            }
            this.username = username;
            return this;
        }

        public StoreUserCredentialRequestBuilder adminUsers(@NonNull List<String> adminUsers) {
            if (adminUsers == null) {
                throw new NullPointerException("adminUsers is marked @NonNull but is null");
            }
            this.adminUsers = adminUsers;
            return this;
        }

        public StoreUserCredentialRequestBuilder metadataCredentials(boolean metadataCredentials) {
            this.metadataCredentials = metadataCredentials;
            return this;
        }

        public StoreUserCredentialRequestBuilder temporaryCredentials(@NonNull TemporaryCredentials temporaryCredentials) {
            if (temporaryCredentials == null) {
                throw new NullPointerException("temporaryCredentials is marked @NonNull but is null");
            }
            this.temporaryCredentials = temporaryCredentials;
            return this;
        }

        public StoreUserCredentialRequest build() {
            return new StoreUserCredentialRequest(this.username, this.adminUsers, this.metadataCredentials, this.temporaryCredentials);
        }

        public String toString() {
            return "StoreUserCredentialRequest.StoreUserCredentialRequestBuilder(username=" + this.username + ", adminUsers=" + this.adminUsers + ", metadataCredentials=" + this.metadataCredentials + ", temporaryCredentials=" + this.temporaryCredentials + ")";
        }
    }
}

