/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor.RequestExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.Secret;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.StoreSecretResponse;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.utils.URIBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;

public class StoreSecretRequest
implements SecretAgentRequest<StoreSecretResponse> {
    private Secret secret;
    @Nullable
    private boolean versioned;
    @Nullable
    private String requestingUser;
    boolean enableUserAuthenticatedNamespaces;
    private String usernameThatCreatedSecret;

    @Override
    public URI getURI(URI baseUri) throws URISyntaxException {
        return new URIBuilder(baseUri).setPath(String.format("/v1/secrets/%s", this.secret.getName())).build();
    }

    @Override
    public RequestExecutor.HttpVerb getHttpVerb() {
        return RequestExecutor.HttpVerb.POST;
    }

    @Override
    public boolean isPathOnly() {
        return false;
    }

    @Override
    public Class<StoreSecretResponse> getResponseType() {
        return StoreSecretResponse.class;
    }

    public static StoreSecretRequestBuilder builder() {
        return new StoreSecretRequestBuilder();
    }

    public Secret getSecret() {
        return this.secret;
    }

    @Nullable
    public boolean isVersioned() {
        return this.versioned;
    }

    @Nullable
    public String getRequestingUser() {
        return this.requestingUser;
    }

    public boolean isEnableUserAuthenticatedNamespaces() {
        return this.enableUserAuthenticatedNamespaces;
    }

    public String getUsernameThatCreatedSecret() {
        return this.usernameThatCreatedSecret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoreSecretRequest)) {
            return false;
        }
        StoreSecretRequest other = (StoreSecretRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Secret this$secret = this.getSecret();
        Secret other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !((Object)this$secret).equals(other$secret)) {
            return false;
        }
        if (this.isVersioned() != other.isVersioned()) {
            return false;
        }
        String this$requestingUser = this.getRequestingUser();
        String other$requestingUser = other.getRequestingUser();
        if (this$requestingUser == null ? other$requestingUser != null : !this$requestingUser.equals(other$requestingUser)) {
            return false;
        }
        if (this.isEnableUserAuthenticatedNamespaces() != other.isEnableUserAuthenticatedNamespaces()) {
            return false;
        }
        String this$usernameThatCreatedSecret = this.getUsernameThatCreatedSecret();
        String other$usernameThatCreatedSecret = other.getUsernameThatCreatedSecret();
        return !(this$usernameThatCreatedSecret == null ? other$usernameThatCreatedSecret != null : !this$usernameThatCreatedSecret.equals(other$usernameThatCreatedSecret));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoreSecretRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Secret $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : ((Object)$secret).hashCode());
        result = result * 59 + (this.isVersioned() ? 79 : 97);
        String $requestingUser = this.getRequestingUser();
        result = result * 59 + ($requestingUser == null ? 43 : $requestingUser.hashCode());
        result = result * 59 + (this.isEnableUserAuthenticatedNamespaces() ? 79 : 97);
        String $usernameThatCreatedSecret = this.getUsernameThatCreatedSecret();
        result = result * 59 + ($usernameThatCreatedSecret == null ? 43 : $usernameThatCreatedSecret.hashCode());
        return result;
    }

    public StoreSecretRequest() {
    }

    public StoreSecretRequest(Secret secret, @Nullable boolean versioned, @Nullable String requestingUser, boolean enableUserAuthenticatedNamespaces, String usernameThatCreatedSecret) {
        this.secret = secret;
        this.versioned = versioned;
        this.requestingUser = requestingUser;
        this.enableUserAuthenticatedNamespaces = enableUserAuthenticatedNamespaces;
        this.usernameThatCreatedSecret = usernameThatCreatedSecret;
    }

    public String toString() {
        return "StoreSecretRequest(secret=" + this.getSecret() + ", versioned=" + this.isVersioned() + ", requestingUser=" + this.getRequestingUser() + ", enableUserAuthenticatedNamespaces=" + this.isEnableUserAuthenticatedNamespaces() + ", usernameThatCreatedSecret=" + this.getUsernameThatCreatedSecret() + ")";
    }

    public static class StoreSecretRequestBuilder {
        private Secret secret;
        private boolean versioned;
        private String requestingUser;
        private boolean enableUserAuthenticatedNamespaces;
        private String usernameThatCreatedSecret;

        StoreSecretRequestBuilder() {
        }

        public StoreSecretRequestBuilder secret(Secret secret) {
            this.secret = secret;
            return this;
        }

        public StoreSecretRequestBuilder versioned(@Nullable boolean versioned) {
            this.versioned = versioned;
            return this;
        }

        public StoreSecretRequestBuilder requestingUser(@Nullable String requestingUser) {
            this.requestingUser = requestingUser;
            return this;
        }

        public StoreSecretRequestBuilder enableUserAuthenticatedNamespaces(boolean enableUserAuthenticatedNamespaces) {
            this.enableUserAuthenticatedNamespaces = enableUserAuthenticatedNamespaces;
            return this;
        }

        public StoreSecretRequestBuilder usernameThatCreatedSecret(String usernameThatCreatedSecret) {
            this.usernameThatCreatedSecret = usernameThatCreatedSecret;
            return this;
        }

        public StoreSecretRequest build() {
            return new StoreSecretRequest(this.secret, this.versioned, this.requestingUser, this.enableUserAuthenticatedNamespaces, this.usernameThatCreatedSecret);
        }

        public String toString() {
            return "StoreSecretRequest.StoreSecretRequestBuilder(secret=" + this.secret + ", versioned=" + this.versioned + ", requestingUser=" + this.requestingUser + ", enableUserAuthenticatedNamespaces=" + this.enableUserAuthenticatedNamespaces + ", usernameThatCreatedSecret=" + this.usernameThatCreatedSecret + ")";
        }
    }
}

