/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import java.util.Optional;

public class SecretAgentClientException
extends RuntimeException {
    private final Optional<Integer> httpResponseCode;

    public SecretAgentClientException(String message) {
        super(message);
        this.httpResponseCode = Optional.empty();
    }

    public SecretAgentClientException(String message, Throwable cause) {
        super(message, cause);
        this.httpResponseCode = Optional.empty();
    }

    public SecretAgentClientException(String message, int httpResponseCode) {
        super(message);
        this.httpResponseCode = Optional.of(httpResponseCode);
    }

    public SecretAgentClientException(String message, Throwable cause, int httpResponseCode) {
        super(message, cause);
        this.httpResponseCode = Optional.of(httpResponseCode);
    }

    @Override
    public String toString() {
        String cause = null;
        if (this.getCause() != null) {
            cause = this.getCause().getClass().getCanonicalName();
        }
        return this.getClass().getSimpleName() + "{httpResponseCode=" + this.httpResponseCode + " message=" + this.getMessage() + " cause.class=" + cause + '}';
    }

    public Optional<Integer> getHttpResponseCode() {
        return this.httpResponseCode;
    }
}

