/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.adapter.ZonedDateTimeJsonAdapter;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.annotations.JsonAdapter;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Secret {
    @NonNull
    String name;
    List<String> adminUsers;
    List<String> accessUsers;
    byte[] secretBytes;
    @JsonAdapter(value=ZonedDateTimeJsonAdapter.class)
    ZonedDateTime expirationDateTime;
    private String version;

    public String toString() {
        return "Secret{name=" + this.name + " adminUsers=" + (this.adminUsers == null ? null : this.adminUsers.stream().collect(Collectors.joining(", "))) + " accessUsers=" + (this.accessUsers == null ? null : this.accessUsers.stream().collect(Collectors.joining(", "))) + " version=" + (this.version == null ? null : this.version) + " expirationDateTime=" + (this.expirationDateTime == null ? "NONE" : this.expirationDateTime.toString()) + " secretBytes=REDACTED" + '}';
    }

    public static SecretBuilder builder() {
        return new SecretBuilder();
    }

    public SecretBuilder toBuilder() {
        return new SecretBuilder().name(this.name).adminUsers(this.adminUsers).accessUsers(this.accessUsers).secretBytes(this.secretBytes).expirationDateTime(this.expirationDateTime).version(this.version);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public List<String> getAdminUsers() {
        return this.adminUsers;
    }

    public List<String> getAccessUsers() {
        return this.accessUsers;
    }

    public byte[] getSecretBytes() {
        return this.secretBytes;
    }

    public ZonedDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public String getVersion() {
        return this.version;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.name = name;
    }

    public void setAdminUsers(List<String> adminUsers) {
        this.adminUsers = adminUsers;
    }

    public void setAccessUsers(List<String> accessUsers) {
        this.accessUsers = accessUsers;
    }

    public void setSecretBytes(byte[] secretBytes) {
        this.secretBytes = secretBytes;
    }

    public void setExpirationDateTime(ZonedDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Secret)) {
            return false;
        }
        Secret other = (Secret)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$adminUsers = this.getAdminUsers();
        List<String> other$adminUsers = other.getAdminUsers();
        if (this$adminUsers == null ? other$adminUsers != null : !((Object)this$adminUsers).equals(other$adminUsers)) {
            return false;
        }
        List<String> this$accessUsers = this.getAccessUsers();
        List<String> other$accessUsers = other.getAccessUsers();
        if (this$accessUsers == null ? other$accessUsers != null : !((Object)this$accessUsers).equals(other$accessUsers)) {
            return false;
        }
        if (!Arrays.equals(this.getSecretBytes(), other.getSecretBytes())) {
            return false;
        }
        ZonedDateTime this$expirationDateTime = this.getExpirationDateTime();
        ZonedDateTime other$expirationDateTime = other.getExpirationDateTime();
        if (this$expirationDateTime == null ? other$expirationDateTime != null : !((Object)this$expirationDateTime).equals(other$expirationDateTime)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Secret;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $adminUsers = this.getAdminUsers();
        result = result * 59 + ($adminUsers == null ? 43 : ((Object)$adminUsers).hashCode());
        List<String> $accessUsers = this.getAccessUsers();
        result = result * 59 + ($accessUsers == null ? 43 : ((Object)$accessUsers).hashCode());
        result = result * 59 + Arrays.hashCode(this.getSecretBytes());
        ZonedDateTime $expirationDateTime = this.getExpirationDateTime();
        result = result * 59 + ($expirationDateTime == null ? 43 : ((Object)$expirationDateTime).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public Secret() {
    }

    public Secret(@NonNull String name, List<String> adminUsers, List<String> accessUsers, byte[] secretBytes, ZonedDateTime expirationDateTime, String version) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.name = name;
        this.adminUsers = adminUsers;
        this.accessUsers = accessUsers;
        this.secretBytes = secretBytes;
        this.expirationDateTime = expirationDateTime;
        this.version = version;
    }

    public static class SecretBuilder {
        private String name;
        private List<String> adminUsers;
        private List<String> accessUsers;
        private byte[] secretBytes;
        private ZonedDateTime expirationDateTime;
        private String version;

        SecretBuilder() {
        }

        public SecretBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            this.name = name;
            return this;
        }

        public SecretBuilder adminUsers(List<String> adminUsers) {
            this.adminUsers = adminUsers;
            return this;
        }

        public SecretBuilder accessUsers(List<String> accessUsers) {
            this.accessUsers = accessUsers;
            return this;
        }

        public SecretBuilder secretBytes(byte[] secretBytes) {
            this.secretBytes = secretBytes;
            return this;
        }

        public SecretBuilder expirationDateTime(ZonedDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            return this;
        }

        public SecretBuilder version(String version) {
            this.version = version;
            return this;
        }

        public Secret build() {
            return new Secret(this.name, this.adminUsers, this.accessUsers, this.secretBytes, this.expirationDateTime, this.version);
        }

        public String toString() {
            return "Secret.SecretBuilder(name=" + this.name + ", adminUsers=" + this.adminUsers + ", accessUsers=" + this.accessUsers + ", secretBytes=" + Arrays.toString(this.secretBytes) + ", expirationDateTime=" + this.expirationDateTime + ", version=" + this.version + ")";
        }
    }
}

