/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class ResourcePrivileges
implements Comparable<ResourcePrivileges> {
    @NonNull
    private final String arn;
    @NonNull
    private final List<String> privilegeFilters;

    @Override
    public int compareTo(ResourcePrivileges o) {
        if (this == o) {
            return 0;
        }
        int arnValue = this.arn.compareTo(o.arn);
        if (arnValue != 0) {
            return arnValue;
        }
        int lengthValue = Integer.compare(this.privilegeFilters.size(), o.privilegeFilters.size());
        if (lengthValue != 0) {
            return lengthValue;
        }
        for (int idx = 0; idx < this.privilegeFilters.size(); ++idx) {
            int curValue = this.privilegeFilters.get(idx).compareTo(o.privilegeFilters.get(idx));
            if (curValue == 0) continue;
            return curValue;
        }
        return 0;
    }

    public String toString() {
        return "ResourcePrivileges{arn='" + this.arn + '\'' + ", privilegeFilters=" + this.privilegeFilters.stream().collect(Collectors.joining(", ")) + '}';
    }

    ResourcePrivileges(@NonNull String arn, @NonNull List<String> privilegeFilters) {
        if (arn == null) {
            throw new NullPointerException("arn is marked @NonNull but is null");
        }
        if (privilegeFilters == null) {
            throw new NullPointerException("privilegeFilters is marked @NonNull but is null");
        }
        this.arn = arn;
        this.privilegeFilters = privilegeFilters;
    }

    public static ResourcePrivilegesBuilder builder() {
        return new ResourcePrivilegesBuilder();
    }

    public ResourcePrivilegesBuilder toBuilder() {
        return new ResourcePrivilegesBuilder().arn(this.arn).privilegeFilters(this.privilegeFilters);
    }

    @NonNull
    public String getArn() {
        return this.arn;
    }

    @NonNull
    public List<String> getPrivilegeFilters() {
        return this.privilegeFilters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcePrivileges)) {
            return false;
        }
        ResourcePrivileges other = (ResourcePrivileges)o;
        String this$arn = this.getArn();
        String other$arn = other.getArn();
        if (this$arn == null ? other$arn != null : !this$arn.equals(other$arn)) {
            return false;
        }
        List<String> this$privilegeFilters = this.getPrivilegeFilters();
        List<String> other$privilegeFilters = other.getPrivilegeFilters();
        return !(this$privilegeFilters == null ? other$privilegeFilters != null : !((Object)this$privilegeFilters).equals(other$privilegeFilters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $arn = this.getArn();
        result = result * 59 + ($arn == null ? 43 : $arn.hashCode());
        List<String> $privilegeFilters = this.getPrivilegeFilters();
        result = result * 59 + ($privilegeFilters == null ? 43 : ((Object)$privilegeFilters).hashCode());
        return result;
    }

    public static class ResourcePrivilegesBuilder {
        private String arn;
        private List<String> privilegeFilters;

        ResourcePrivilegesBuilder() {
        }

        public ResourcePrivilegesBuilder arn(@NonNull String arn) {
            if (arn == null) {
                throw new NullPointerException("arn is marked @NonNull but is null");
            }
            this.arn = arn;
            return this;
        }

        public ResourcePrivilegesBuilder privilegeFilters(@NonNull List<String> privilegeFilters) {
            if (privilegeFilters == null) {
                throw new NullPointerException("privilegeFilters is marked @NonNull but is null");
            }
            this.privilegeFilters = privilegeFilters;
            return this;
        }

        public ResourcePrivileges build() {
            return new ResourcePrivileges(this.arn, this.privilegeFilters);
        }

        public String toString() {
            return "ResourcePrivileges.ResourcePrivilegesBuilder(arn=" + this.arn + ", privilegeFilters=" + this.privilegeFilters + ")";
        }
    }
}

