/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.Utils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor.RequestExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetUnfilteredTableResponse;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.utils.URIBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class GetUnfilteredTableRequest
implements SecretAgentRequest<GetUnfilteredTableResponse> {
    @NonNull
    private final long userId;
    @Nullable
    private final String catalogId;
    @NonNull
    private final String databaseName;
    @NonNull
    private final String name;

    @Override
    public URI getURI(URI baseUri) throws URISyntaxException {
        String path = String.format("/v1/awsLakeFormation/getUnfilteredTable/%s/%s/%s/%s", this.userId, StringUtils.isBlank(this.catalogId) ? "null" : Utils.extractAccountIdFromCatalogId(this.catalogId), this.databaseName, this.name);
        return new URIBuilder(baseUri).setPath(path).build();
    }

    @Override
    public RequestExecutor.HttpVerb getHttpVerb() {
        return RequestExecutor.HttpVerb.GET;
    }

    @Override
    public boolean isPathOnly() {
        return true;
    }

    @Override
    public Class<GetUnfilteredTableResponse> getResponseType() {
        return GetUnfilteredTableResponse.class;
    }

    GetUnfilteredTableRequest(@NonNull long userId, @Nullable String catalogId, @NonNull String databaseName, @NonNull String name) {
        if (databaseName == null) {
            throw new NullPointerException("databaseName is marked @NonNull but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.userId = userId;
        this.catalogId = catalogId;
        this.databaseName = databaseName;
        this.name = name;
    }

    public static GetUnfilteredTableRequestBuilder builder() {
        return new GetUnfilteredTableRequestBuilder();
    }

    @NonNull
    public long getUserId() {
        return this.userId;
    }

    @Nullable
    public String getCatalogId() {
        return this.catalogId;
    }

    @NonNull
    public String getDatabaseName() {
        return this.databaseName;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetUnfilteredTableRequest)) {
            return false;
        }
        GetUnfilteredTableRequest other = (GetUnfilteredTableRequest)o;
        if (this.getUserId() != other.getUserId()) {
            return false;
        }
        String this$catalogId = this.getCatalogId();
        String other$catalogId = other.getCatalogId();
        if (this$catalogId == null ? other$catalogId != null : !this$catalogId.equals(other$catalogId)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $userId = this.getUserId();
        result = result * 59 + (int)($userId >>> 32 ^ $userId);
        String $catalogId = this.getCatalogId();
        result = result * 59 + ($catalogId == null ? 43 : $catalogId.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "GetUnfilteredTableRequest(userId=" + this.getUserId() + ", catalogId=" + this.getCatalogId() + ", databaseName=" + this.getDatabaseName() + ", name=" + this.getName() + ")";
    }

    public static class GetUnfilteredTableRequestBuilder {
        private long userId;
        private String catalogId;
        private String databaseName;
        private String name;

        GetUnfilteredTableRequestBuilder() {
        }

        public GetUnfilteredTableRequestBuilder userId(@NonNull long userId) {
            this.userId = userId;
            return this;
        }

        public GetUnfilteredTableRequestBuilder catalogId(@Nullable String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public GetUnfilteredTableRequestBuilder databaseName(@NonNull String databaseName) {
            if (databaseName == null) {
                throw new NullPointerException("databaseName is marked @NonNull but is null");
            }
            this.databaseName = databaseName;
            return this;
        }

        public GetUnfilteredTableRequestBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            this.name = name;
            return this;
        }

        public GetUnfilteredTableRequest build() {
            return new GetUnfilteredTableRequest(this.userId, this.catalogId, this.databaseName, this.name);
        }

        public String toString() {
            return "GetUnfilteredTableRequest.GetUnfilteredTableRequestBuilder(userId=" + this.userId + ", catalogId=" + this.catalogId + ", databaseName=" + this.databaseName + ", name=" + this.name + ")";
        }
    }
}

